/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.handler;

import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelHandlerContext;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import com.alibaba.csp.ahas.shaded.io.netty.handler.timeout.IdleState;
import com.alibaba.csp.ahas.shaded.io.netty.handler.timeout.IdleStateEvent;
import com.alibaba.csp.sentinel.cluster.ClusterStateManager;
import com.alibaba.csp.sentinel.cluster.TokenResultStatus;
import com.alibaba.csp.sentinel.cluster.client.auth.ClientAuthConfigRegistry;
import com.alibaba.csp.sentinel.cluster.client.handler.TokenClientPromiseHolder;
import com.alibaba.csp.sentinel.cluster.registry.ConfigSupplierRegistry;
import com.alibaba.csp.sentinel.cluster.request.ClusterRequest;
import com.alibaba.csp.sentinel.cluster.request.data.ConnectRequestData;
import com.alibaba.csp.sentinel.cluster.response.ClusterResponse;
import com.alibaba.csp.sentinel.cluster.response.data.ConnectResponseData;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicInteger;

public class TokenClientHandler
extends ChannelInboundHandlerAdapter {
    private final AtomicInteger currentState;
    private final Runnable disconnectCallback;

    public TokenClientHandler(AtomicInteger currentState, Runnable disconnectCallback) {
        this.currentState = currentState;
        this.disconnectCallback = disconnectCallback;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.currentState.set(2);
        this.fireClientConnect(ctx);
        RecordLog.info("[TokenClientHandler] Client handler active, remote address: " + this.getRemoteAddress(ctx), new Object[0]);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ClusterResponse) {
            ClusterResponse response = (ClusterResponse)msg;
            if (response.getType() == 0) {
                this.handleConnectResponse(ctx, response);
                return;
            }
            TokenClientPromiseHolder.completePromise(response.getId(), response);
        }
    }

    private void fireClientConnect(ChannelHandlerContext ctx) {
        ClusterRequest<ConnectRequestData> ping = new ClusterRequest().setId(0).setType(0).setData(new ConnectRequestData().setNamespace(ConfigSupplierRegistry.getNamespaceSupplier().get()).setCredentials(ClientAuthConfigRegistry.getClientCredentialSupplier().getCredentials()));
        ctx.writeAndFlush(ping);
    }

    private void handleConnectResponse(ChannelHandlerContext ctx, ClusterResponse response) {
        ConnectResponseData data = (ConnectResponseData)response.getData();
        if (response.getStatus() == 0) {
            RecordLog.info("[TokenClientHandler] Client connect OK (target server: {0}, connected count: {1})", this.getRemoteAddress(ctx), data.getConnectedCount());
        } else {
            RecordLog.warn("[TokenClientHandler] Client connect failed ({0}), target server: <{1}>, message: {2}", TokenResultStatus.toStatusString(response.getStatus()), this.getRemoteAddress(ctx), data.getMessage());
            ClusterStateManager.applyState(-1);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        RecordLog.warn("[TokenClientHandler] Client exception caught", cause);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        RecordLog.info("[TokenClientHandler] Client handler inactive, remote address: " + this.getRemoteAddress(ctx), new Object[0]);
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        RecordLog.info("[TokenClientHandler] Client channel unregistered, remote address: " + this.getRemoteAddress(ctx), new Object[0]);
        this.currentState.set(0);
        this.disconnectCallback.run();
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.WRITER_IDLE) {
            ctx.writeAndFlush(new ClusterRequest().setId(1024).setType(100).setData(null));
        }
    }

    private String getRemoteAddress(ChannelHandlerContext ctx) {
        if (ctx.channel().remoteAddress() == null) {
            return null;
        }
        InetSocketAddress inetAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        return inetAddress.getAddress().getHostAddress() + ":" + inetAddress.getPort();
    }

    public int getCurrentState() {
        return this.currentState.get();
    }

    public boolean hasStarted() {
        return this.getCurrentState() == 2;
    }
}

