/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.log;

import com.alibaba.csp.sentinel.eagleeye.EagleEye;
import com.alibaba.csp.sentinel.eagleeye.StatLogger;
import com.alibaba.csp.sentinel.eagleeye.StatLoggerBuilder;
import com.alibaba.csp.sentinel.log.LogBase;
import com.alibaba.csp.sentinel.util.PidUtil;

public final class ClusterClientStatLogUtil {
    private static final String FILE_NAME = "sentinel-cluster-client.log";
    private static StatLogger statLogger;

    public static void log(String msg) {
        statLogger.stat(msg).count();
    }

    public static void log(String msg, int count) {
        statLogger.stat(msg).count(count);
    }

    private ClusterClientStatLogUtil() {
    }

    static {
        String path = LogBase.getLogBaseDir() + FILE_NAME;
        if (LogBase.isLogNameUsePid()) {
            path = path + ".pid" + PidUtil.getPid();
        }
        statLogger = ((StatLoggerBuilder)((StatLoggerBuilder)((StatLoggerBuilder)((StatLoggerBuilder)EagleEye.statLoggerBuilder("sentinel-cluster-client-record").intervalSeconds(1).entryDelimiter('|')).keyDelimiter(',').valueDelimiter(',').maxEntryCount(5000).configLogFilePath(path)).maxFileSizeMB(50L)).maxBackupIndex(5)).buildSingleton();
    }
}

