/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.stat;

import com.alibaba.csp.sentinel.cluster.stat.ClusterStatSnapshot;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClusterStatCacheManager {
    private static Map<Long, ClusterStatSnapshot> clusterStatCache = new ConcurrentHashMap<Long, ClusterStatSnapshot>();

    public static void updateSnapshot(Long id, long bucketStart, long remainingCount) {
        AssertUtil.assertNotNull(id, "id cannot be null");
        ClusterStatSnapshot snapshot = clusterStatCache.get(id);
        if (snapshot == null) {
            clusterStatCache.put(id, new ClusterStatSnapshot(bucketStart, remainingCount));
            return;
        }
        if (snapshot.getBucketStart() != bucketStart) {
            snapshot.setBucketStart(bucketStart);
        }
        snapshot.setRemainingCount(remainingCount);
    }

    public static ClusterStatSnapshot getSnapshot(Long id) {
        AssertUtil.assertNotNull(id, "id cannot be null");
        return clusterStatCache.get(id);
    }

    private ClusterStatCacheManager() {
    }
}

