/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.handler;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.ClusterHistogram;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Compass;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Counter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.FastCompass;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Gauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Histogram;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.IMetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Meter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricRegistry;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.StringUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Timer;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.CollectLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricsCollector;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricsCollectorFactory;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.metric.MetricNode;
import com.alibaba.csp.sentinel.node.metric.MetricSearcher;
import com.alibaba.csp.sentinel.node.metric.MetricWriter;
import com.alibaba.csp.sentinel.util.PidUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;

@CommandMapping(name="metric", desc="get and aggregate metrics, accept param: startTime={startTime}&endTime={endTime}&maxLines={maxLines}&identify={resourceName}")
public class SendMetricCommandHandler
implements CommandHandler<String> {
    private MetricSearcher searcher;
    private final Object lock = new Object();
    private static IMetricManager metricsManager = MetricManager.getIMetricManager();
    private static final double rateFactor = TimeUnit.SECONDS.toSeconds(1L);
    private static final double durationFactor = 1.0 / (double)TimeUnit.MILLISECONDS.toNanos(1L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResponse<String> handle(CommandRequest request) {
        List<MetricNode> list;
        if (this.searcher == null) {
            Object object = this.lock;
            synchronized (object) {
                String appName = SentinelConfig.getAppName();
                if (appName == null) {
                    appName = "";
                }
                if (this.searcher == null) {
                    this.searcher = new MetricSearcher(MetricWriter.METRIC_BASE_DIR, MetricWriter.formMetricFileName(appName, PidUtil.getPid()));
                }
            }
        }
        String startTimeStr = request.getParam("startTime");
        String endTimeStr = request.getParam("endTime");
        String maxLinesStr = request.getParam("maxLines");
        String identity = request.getParam("identity");
        String metrics = request.getParam("metrics");
        String metricsGroup = request.getParam("metricsGroup");
        long startTime = -1L;
        int maxLines = 6000;
        if (!StringUtil.isNotBlank(startTimeStr)) {
            return CommandResponse.ofSuccess("");
        }
        startTime = Long.parseLong(startTimeStr);
        try {
            if (StringUtil.isNotBlank(endTimeStr)) {
                long endTime = Long.parseLong(endTimeStr);
                list = this.searcher.findByTimeAndResource(startTime, endTime, identity);
            } else {
                if (StringUtil.isNotBlank(maxLinesStr)) {
                    maxLines = Integer.parseInt(maxLinesStr);
                }
                maxLines = Math.min(maxLines, 12000);
                list = this.searcher.find(startTime, maxLines);
            }
        }
        catch (Exception ex) {
            return CommandResponse.ofFailure(new RuntimeException("Error when retrieving metrics", ex));
        }
        if (list == null) {
            list = new ArrayList<MetricNode>(0);
        }
        if (StringUtil.isBlank(identity)) {
            this.addDubboMetrics(list, metrics, metricsGroup);
        }
        StringBuilder sb = new StringBuilder();
        for (MetricNode node : list) {
            sb.append(node.toThinString()).append("\n");
        }
        return CommandResponse.ofSuccess(sb.toString());
    }

    private void addDubboMetrics(List<MetricNode> list, String metricName, String metricsGroup) {
        List<String> metricNames;
        List<String> groups = SendMetricCommandHandler.getMetricsParams(metricsGroup);
        if (groups == null || groups.size() < 1) {
            groups = metricsManager.listMetricGroups();
        }
        boolean userMetricFilter = (metricNames = SendMetricCommandHandler.getMetricsParams(metricName)).size() > 0;
        for (String group : groups) {
            try {
                MetricRegistry registry = metricsManager.getMetricRegistryByGroup(group);
                List<MetricObject> metrics = this.getDubboMetrics(registry);
                if (metrics == null | metrics.size() < 1) continue;
                for (MetricObject metric : metrics) {
                    if (!userMetricFilter) {
                        list.add(this.dubboMetricToNode(metric));
                        continue;
                    }
                    if (!userMetricFilter || !metricNames.contains(metric.getMetric())) continue;
                    list.add(this.dubboMetricToNode(metric));
                }
            }
            catch (Throwable e) {
                RecordLog.warn("[SendMetricCommandHandler] WARN: Get dubbo metrics error ", group, e);
            }
        }
    }

    private MetricNode dubboMetricToNode(MetricObject metric) {
        MetricNode node = new MetricNode();
        Number value = (Number)metric.getValue();
        node.setPassQps((long)(value.doubleValue() * 10000.0));
        node.setTimestamp(metric.getTimestamp());
        node.setResource(metric.getMetric());
        node.setClassification(9999);
        return node;
    }

    private List<MetricObject> getDubboMetrics(MetricRegistry registry) {
        return this.getDubboMetrics(registry, null);
    }

    private List<MetricObject> getDubboMetrics(MetricRegistry registry, MetricFilter filter) {
        long ts = System.currentTimeMillis();
        MetricsCollector collector = MetricsCollectorFactory.createNew(CollectLevel.NORMAL, rateFactor, durationFactor, filter);
        SortedMap<MetricName, Gauge> gauges = filter == null ? registry.getGauges() : registry.getGauges(filter);
        for (Map.Entry<MetricName, Gauge> entry : gauges.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        SortedMap<MetricName, Counter> counters = filter == null ? registry.getCounters() : registry.getCounters(filter);
        for (Map.Entry<MetricName, Counter> entry : counters.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        SortedMap<MetricName, Meter> sortedMap = filter == null ? registry.getMeters() : registry.getMeters(filter);
        for (Map.Entry<MetricName, Meter> entry : sortedMap.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        SortedMap<MetricName, Histogram> sortedMap2 = filter == null ? registry.getHistograms() : registry.getHistograms(filter);
        for (Map.Entry<MetricName, Histogram> entry : sortedMap2.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        SortedMap<MetricName, Timer> sortedMap3 = filter == null ? registry.getTimers() : registry.getTimers(filter);
        for (Map.Entry<MetricName, Timer> entry : sortedMap3.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        SortedMap<MetricName, Compass> sortedMap4 = filter == null ? registry.getCompasses() : registry.getCompasses(filter);
        for (Map.Entry<MetricName, Compass> entry : sortedMap4.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        SortedMap<MetricName, FastCompass> sortedMap5 = filter == null ? registry.getFastCompasses() : registry.getFastCompasses(filter);
        for (Map.Entry<MetricName, FastCompass> entry : sortedMap5.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        SortedMap<MetricName, ClusterHistogram> sortedMap6 = filter == null ? registry.getClusterHistograms() : registry.getClusterHistograms(filter);
        for (Map.Entry<MetricName, ClusterHistogram> entry : sortedMap6.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        return collector.build();
    }

    private static List<String> getMetricsParams(String origin) {
        if (StringUtils.isBlank(origin)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> params = new ArrayList<String>();
        for (String group : origin.split(",")) {
            params.add(group);
        }
        return params;
    }
}

