/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.setting.general;

import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.property.SimplePropertyListener;
import com.alibaba.csp.sentinel.setting.general.SentinelGeneralSettingEntity;
import com.alibaba.csp.sentinel.util.AssertUtil;

public final class GeneralSettingManager {
    private static volatile SentinelGeneralSettingEntity currentSetting = null;
    private static final GeneralSettingPropertyListener LISTENER = new GeneralSettingPropertyListener();
    private static SentinelProperty<SentinelGeneralSettingEntity> currentProperty = new DynamicSentinelProperty<SentinelGeneralSettingEntity>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<SentinelGeneralSettingEntity> property) {
        AssertUtil.notNull(property, "property cannot be null");
        GeneralSettingPropertyListener generalSettingPropertyListener = LISTENER;
        synchronized (generalSettingPropertyListener) {
            RecordLog.info("[GeneralSettingManager] Registering new property to general setting manager", new Object[0]);
            currentProperty.removeListener(LISTENER);
            property.addListener(LISTENER);
            currentProperty = property;
        }
    }

    public static SentinelGeneralSettingEntity getCurrentSetting() {
        return currentSetting;
    }

    public static boolean isValidProperties(SentinelGeneralSettingEntity setting) {
        return setting != null && GeneralSettingManager.isPositive(setting.getMaxContextAmount()) && GeneralSettingManager.isPositive(setting.getMaxOriginAmount()) && GeneralSettingManager.isPositive(setting.getMaxResourceAmount()) && GeneralSettingManager.isPositive(setting.getStatisticMaxRt());
    }

    private static boolean isPositive(Integer i) {
        return i != null && i > 0;
    }

    private GeneralSettingManager() {
    }

    static {
        currentProperty.addListener(LISTENER);
    }

    private static class GeneralSettingPropertyListener
    extends SimplePropertyListener<SentinelGeneralSettingEntity> {
        private GeneralSettingPropertyListener() {
        }

        @Override
        public synchronized void configUpdate(SentinelGeneralSettingEntity properties) {
            if (properties == null) {
                return;
            }
            if (!GeneralSettingManager.isValidProperties(properties)) {
                RecordLog.warn("[GeneralSettingManager] Ignoring invalid setting: " + properties, new Object[0]);
                return;
            }
            int maxContextAmount = properties.getMaxContextAmount();
            int maxResAmount = properties.getMaxResourceAmount();
            int maxOriginAmount = properties.getMaxOriginAmount();
            int maxStatRt = properties.getStatisticMaxRt();
            if (maxContextAmount != SentinelConfig.maxEntranceContextAmount()) {
                RecordLog.info("[GeneralSettingManager] Setting maxEntranceContextAmount to " + maxContextAmount, new Object[0]);
                SentinelConfig.setConfig("csp.sentinel.context.amount.limit", String.valueOf(maxContextAmount));
            }
            if (maxResAmount != SentinelConfig.maxResourceAmount()) {
                RecordLog.info("[GeneralSettingManager] Setting maxResourceAmount to " + maxResAmount, new Object[0]);
                SentinelConfig.setConfig("csp.sentinel.resource.amount.limit", String.valueOf(maxResAmount));
            }
            if (maxOriginAmount != SentinelConfig.maxOriginAmount()) {
                RecordLog.info("[GeneralSettingManager] Setting maxOriginAmount to " + maxOriginAmount, new Object[0]);
                SentinelConfig.setConfig("csp.sentinel.statistic.origin.amount.limit", String.valueOf(maxOriginAmount));
            }
            if (maxStatRt != SentinelConfig.statisticMaxRt()) {
                RecordLog.info("[GeneralSettingManager] Setting statisticMaxRt to " + maxStatRt, new Object[0]);
                SentinelConfig.setConfig("csp.sentinel.statistic.max.rt", String.valueOf(maxStatRt));
            }
            currentSetting = properties;
        }
    }
}

