/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker;

import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreaker;
import com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreakerStateChangeObserver;
import com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.EventObserverRegistry;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractCircuitBreaker
implements CircuitBreaker {
    protected final DegradeRule rule;
    protected final int retryTimeoutMs;
    private final EventObserverRegistry observerRegistry;
    protected final AtomicReference<CircuitBreaker.State> currentState = new AtomicReference<CircuitBreaker.State>(CircuitBreaker.State.CLOSED);
    protected volatile long nextRetryTimestamp;

    public AbstractCircuitBreaker(DegradeRule rule) {
        this(rule, EventObserverRegistry.getInstance());
    }

    AbstractCircuitBreaker(DegradeRule rule, EventObserverRegistry observerRegistry) {
        AssertUtil.notNull(observerRegistry, "observerRegistry cannot be null");
        if (!DegradeRuleManager.isValidRule(rule)) {
            throw new IllegalArgumentException("Invalid DegradeRule: " + rule);
        }
        this.observerRegistry = observerRegistry;
        this.rule = rule;
        this.retryTimeoutMs = rule.getTimeWindow() * 1000;
    }

    @Override
    public DegradeRule getRule() {
        return this.rule;
    }

    @Override
    public CircuitBreaker.State currentState() {
        return this.currentState.get();
    }

    @Override
    public boolean tryPass() {
        if (this.currentState.get() == CircuitBreaker.State.CLOSED) {
            return true;
        }
        if (this.currentState.get() == CircuitBreaker.State.OPEN) {
            return this.retryTimeoutArrived() && this.fromOpenToHalfOpen();
        }
        return false;
    }

    abstract void resetStat();

    protected boolean retryTimeoutArrived() {
        return TimeUtil.currentTimeMillis() >= this.nextRetryTimestamp;
    }

    protected void updateNextRetryTimestamp() {
        this.nextRetryTimestamp = TimeUtil.currentTimeMillis() + (long)this.retryTimeoutMs;
    }

    protected boolean fromCloseToOpen(double snapshotValue) {
        CircuitBreaker.State prev = CircuitBreaker.State.CLOSED;
        if (this.currentState.compareAndSet(prev, CircuitBreaker.State.OPEN)) {
            this.updateNextRetryTimestamp();
            for (CircuitBreakerStateChangeObserver observer : this.observerRegistry.getStateChangeObservers()) {
                observer.onTransformToOpen(prev, this.rule, snapshotValue);
            }
            return true;
        }
        return false;
    }

    protected boolean fromOpenToHalfOpen() {
        if (this.currentState.compareAndSet(CircuitBreaker.State.OPEN, CircuitBreaker.State.HALF_OPEN)) {
            this.resetStat();
            for (CircuitBreakerStateChangeObserver observer : this.observerRegistry.getStateChangeObservers()) {
                observer.onTransformToHalfOpen(CircuitBreaker.State.OPEN, this.rule);
            }
            return true;
        }
        return false;
    }

    protected boolean fromHalfOpenToOpen(double snapshotValue) {
        if (this.currentState.compareAndSet(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.OPEN)) {
            this.updateNextRetryTimestamp();
            for (CircuitBreakerStateChangeObserver observer : this.observerRegistry.getStateChangeObservers()) {
                observer.onTransformToOpen(CircuitBreaker.State.HALF_OPEN, this.rule, snapshotValue);
            }
            return true;
        }
        return false;
    }

    protected boolean fromHalfOpenToClose() {
        if (this.currentState.compareAndSet(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.CLOSED)) {
            this.resetStat();
            for (CircuitBreakerStateChangeObserver observer : this.observerRegistry.getStateChangeObservers()) {
                observer.onTransformToClosed(CircuitBreaker.State.HALF_OPEN, this.rule);
            }
            return true;
        }
        return false;
    }

    protected void transformToOpen(double triggerValue) {
        CircuitBreaker.State cs = this.currentState.get();
        switch (cs) {
            case CLOSED: {
                this.fromCloseToOpen(triggerValue);
                break;
            }
            case HALF_OPEN: {
                this.fromHalfOpenToOpen(triggerValue);
                break;
            }
        }
    }
}

