/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker;

import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.AbstractCircuitBreaker;
import com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreaker;
import com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.EventObserverRegistry;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractRatioBasedCircuitBreaker
extends AbstractCircuitBreaker {
    protected final double ratioThreshold;
    protected final int halfOpenBaseAmountPerStep;
    protected final int halfOpenRecoveryStepNum;
    protected AtomicInteger curPassAmountDuringRecovery = new AtomicInteger(0);
    protected AtomicInteger curCompleteAmountDuringRecovery = new AtomicInteger(0);

    public AbstractRatioBasedCircuitBreaker(DegradeRule rule, double ratioThreshold) {
        this(rule, ratioThreshold, EventObserverRegistry.getInstance());
    }

    AbstractRatioBasedCircuitBreaker(DegradeRule rule, double ratioThreshold, EventObserverRegistry observerRegistry) {
        super(rule, observerRegistry);
        this.ratioThreshold = ratioThreshold;
        this.halfOpenBaseAmountPerStep = rule.getHalfOpenBaseAmountPerStep();
        this.halfOpenRecoveryStepNum = rule.getHalfOpenRecoveryStepNum();
    }

    @Override
    public boolean tryPass() {
        if (this.currentState.get() == CircuitBreaker.State.CLOSED) {
            return true;
        }
        if (this.currentState.get() == CircuitBreaker.State.OPEN) {
            return this.retryTimeoutArrived() && this.fromOpenToHalfOpen();
        }
        if (this.currentState.get() == CircuitBreaker.State.HALF_OPEN) {
            boolean permitted;
            int completeStep;
            int passStep = this.curPassAmountDuringRecovery.get() / this.halfOpenBaseAmountPerStep + 1;
            if (passStep > (completeStep = this.curCompleteAmountDuringRecovery.get() / this.halfOpenBaseAmountPerStep + 1)) {
                return false;
            }
            if (passStep == this.halfOpenRecoveryStepNum) {
                this.curPassAmountDuringRecovery.incrementAndGet();
                return true;
            }
            if (passStep > this.halfOpenRecoveryStepNum) {
                return false;
            }
            int upperBound = passStep * 100 / this.halfOpenRecoveryStepNum;
            boolean bl = permitted = ThreadLocalRandom.current().nextInt(0, 100) <= upperBound;
            if (permitted) {
                this.curPassAmountDuringRecovery.incrementAndGet();
            }
            return permitted;
        }
        return false;
    }

    protected void handleStateChangeToHalfOpenWhenThresholdExceeded(long triggerCount, long totalCount) {
        int totalRecovery = this.curCompleteAmountDuringRecovery.incrementAndGet();
        if (totalRecovery % this.halfOpenBaseAmountPerStep == 0) {
            double currentRatio = (double)triggerCount * 1.0 / (double)totalCount;
            if (currentRatio > this.ratioThreshold) {
                this.transformToOpen(currentRatio);
            } else if (totalRecovery / this.halfOpenBaseAmountPerStep == this.halfOpenRecoveryStepNum) {
                this.fromHalfOpenToClose();
            }
        }
    }
}

