/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.cluster;

import com.alibaba.csp.sentinel.cluster.TokenResult;
import com.alibaba.csp.sentinel.cluster.TokenService;
import com.alibaba.csp.sentinel.cluster.client.TokenClientProvider;
import com.alibaba.csp.sentinel.cluster.server.EmbeddedClusterTokenServerProvider;
import com.alibaba.csp.sentinel.cluster.stat.ClusterFlowBatchStat;
import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleChecker;
import com.alibaba.csp.sentinel.slots.statistic.base.LeapArray;
import com.alibaba.csp.sentinel.slots.statistic.base.WindowWrap;
import com.alibaba.csp.sentinel.util.function.Tuple2;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ClusterTokenRequestCollapser {
    private static volatile Map<Long, BatchFlowSingleBucketSlidingWindow> statMap = new HashMap<Long, BatchFlowSingleBucketSlidingWindow>();
    private static Thread loopTask;
    private static ExecutorService pool;
    private static final Object LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleBatchStatChange(Set<Tuple2<Long, FlowRule>> newSet) {
        if (newSet == null || newSet.isEmpty()) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            HashMap<Long, BatchFlowSingleBucketSlidingWindow> oldMap = new HashMap<Long, BatchFlowSingleBucketSlidingWindow>(statMap);
            HashMap<Long, BatchFlowSingleBucketSlidingWindow> newMap = new HashMap<Long, BatchFlowSingleBucketSlidingWindow>(statMap.size());
            for (Tuple2<Long, FlowRule> toAdd : newSet) {
                BatchFlowSingleBucketSlidingWindow w = (BatchFlowSingleBucketSlidingWindow)oldMap.get(toAdd.r1);
                FlowRule rule = (FlowRule)toAdd.r2;
                if (w != null && w.getRule().equals(rule)) {
                    newMap.put((Long)toAdd.r1, w);
                    continue;
                }
                newMap.put((Long)toAdd.r1, new BatchFlowSingleBucketSlidingWindow(rule));
            }
            statMap = newMap;
        }
    }

    static void stopSendTask() {
        if (loopTask != null) {
            loopTask.interrupt();
        }
    }

    public static Boolean tryAcquireToken(Long id, int acquireCount) {
        BatchFlowSingleBucketSlidingWindow w = statMap.get(id);
        if (w == null) {
            return null;
        }
        ClusterFlowBatchStat stat = (ClusterFlowBatchStat)w.currentWindow().value();
        long curRemaining = stat.getRemainingCount();
        if (curRemaining - (long)stat.getOccupied().get() >= (long)acquireCount) {
            stat.getOccupied().addAndGet(acquireCount);
            return true;
        }
        return false;
    }

    private ClusterTokenRequestCollapser() {
    }

    static {
        LOCK = new Object();
        try {
            if (TokenClientProvider.getClient() != null || EmbeddedClusterTokenServerProvider.getServer() != null) {
                pool = new ThreadPoolExecutor(4, 4, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(64), new NamedThreadFactory("sentinel-cluster-token-batch-request-task", true), new ThreadPoolExecutor.DiscardOldestPolicy());
                loopTask = new Thread(new BatchSendTask());
                loopTask.setDaemon(true);
                loopTask.setName("sentinel-cluster-token-batch-request-master-loop-task");
                loopTask.start();
                RecordLog.info("[ClusterTokenRequestCollapser] Cluster flow batch request sender task started", new Object[0]);
            }
        }
        catch (Throwable t) {
            RecordLog.warn("Failed to initialize ClusterFlowCollapser", t);
        }
    }

    static class BatchFlowSingleBucketSlidingWindow
    extends LeapArray<ClusterFlowBatchStat> {
        private final FlowRule rule;
        private final long fullCount;

        public BatchFlowSingleBucketSlidingWindow(FlowRule rule) {
            super(1, rule.getClusterConfig().getWindowIntervalMs());
            this.rule = rule;
            int thresholdType = rule.getClusterConfig().getThresholdType();
            this.fullCount = thresholdType == 1 ? (long)rule.getCount() : Integer.MAX_VALUE;
        }

        @Override
        public ClusterFlowBatchStat newEmptyBucket(long timeMillis) {
            return new ClusterFlowBatchStat().reset(this.fullCount);
        }

        @Override
        protected WindowWrap<ClusterFlowBatchStat> resetWindowTo(WindowWrap<ClusterFlowBatchStat> b, long startTime) {
            b.resetTo(startTime);
            b.value().reset(this.fullCount);
            return b;
        }

        public FlowRule getRule() {
            return this.rule;
        }
    }

    static class BatchSendTask
    implements Runnable {
        BatchSendTask() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                if (!statMap.isEmpty()) {
                    this.doSend();
                }
                this.silentSleep(ThreadLocalRandom.current().nextInt(30, 70));
            }
            return;
        }

        private void doSend() {
            final TokenService tokenService = FlowRuleChecker.pickClusterService();
            if (tokenService == null || pool == null) {
                return;
            }
            for (final Map.Entry e : statMap.entrySet()) {
                WindowWrap prevBucket = ((BatchFlowSingleBucketSlidingWindow)e.getValue()).currentWindow();
                final long lastBucketStart = prevBucket.windowStart();
                final int beforeOccupied = ((ClusterFlowBatchStat)prevBucket.value()).getOccupied().get();
                if (beforeOccupied <= 0) continue;
                pool.submit(new Runnable(){

                    @Override
                    public void run() {
                        long sendTime = System.currentTimeMillis();
                        TokenResult result = tokenService.requestToken((Long)e.getKey(), beforeOccupied, false, true);
                        if (result.getStatus() <= -1) {
                            return;
                        }
                        long recvTime = System.currentTimeMillis();
                        WindowWrap curBucket = ((BatchFlowSingleBucketSlidingWindow)e.getValue()).currentWindow();
                        int clusterRemaining = result.getRemaining();
                        if (curBucket.windowStart() > lastBucketStart) {
                            ((ClusterFlowBatchStat)curBucket.value()).getOccupied().set(0);
                            return;
                        }
                        int deltaOccupied = Math.max(((ClusterFlowBatchStat)curBucket.value()).getOccupied().get() - beforeOccupied, 0);
                        ((ClusterFlowBatchStat)curBucket.value()).reset(clusterRemaining, deltaOccupied);
                    }
                });
            }
        }

        private void silentSleep(long ms) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

