/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.param;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.statistic.cache.CacheMap;
import com.alibaba.csp.sentinel.slots.statistic.cache.ConcurrentLinkedHashMapWrapper;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ParameterMetric {
    private static final int THREAD_COUNT_MAX_CAPACITY = 4000;
    private static final int BASE_PARAM_MAX_CAPACITY = 4000;
    private static final int TOTAL_MAX_CAPACITY = 200000;
    private final Object lock = new Object();
    private final Map<ParamFlowRule, CacheMap<Object, AtomicLong>> ruleTimeCounters = new HashMap<ParamFlowRule, CacheMap<Object, AtomicLong>>();
    private final Map<ParamFlowRule, CacheMap<Object, AtomicLong>> ruleTokenCounter = new HashMap<ParamFlowRule, CacheMap<Object, AtomicLong>>();
    private final Map<Integer, CacheMap<Object, AtomicInteger>> threadCountMap = new HashMap<Integer, CacheMap<Object, AtomicInteger>>();

    public CacheMap<Object, AtomicLong> getRuleTokenCounter(ParamFlowRule rule) {
        return this.ruleTokenCounter.get(rule);
    }

    public CacheMap<Object, AtomicLong> getRuleTimeCounter(ParamFlowRule rule) {
        return this.ruleTimeCounters.get(rule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.threadCountMap.clear();
            this.ruleTimeCounters.clear();
            this.ruleTokenCounter.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearForRule(ParamFlowRule rule) {
        Object object = this.lock;
        synchronized (object) {
            this.ruleTimeCounters.remove(rule);
            this.ruleTokenCounter.remove(rule);
            this.threadCountMap.remove(rule.getParamIdx());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(ParamFlowRule rule) {
        long size;
        Object object;
        if (!this.ruleTimeCounters.containsKey(rule)) {
            object = this.lock;
            synchronized (object) {
                if (this.ruleTimeCounters.get(rule) == null) {
                    size = Math.min(4000L * rule.getDurationInSec(), 200000L);
                    this.ruleTimeCounters.put(rule, new ConcurrentLinkedHashMapWrapper(size));
                }
            }
        }
        if (!this.ruleTokenCounter.containsKey(rule)) {
            object = this.lock;
            synchronized (object) {
                if (this.ruleTokenCounter.get(rule) == null) {
                    size = Math.min(4000L * rule.getDurationInSec(), 200000L);
                    this.ruleTokenCounter.put(rule, new ConcurrentLinkedHashMapWrapper(size));
                }
            }
        }
        if (!this.threadCountMap.containsKey(rule.getParamIdx())) {
            object = this.lock;
            synchronized (object) {
                if (this.threadCountMap.get(rule.getParamIdx()) == null) {
                    this.threadCountMap.put(rule.getParamIdx(), new ConcurrentLinkedHashMapWrapper(4000L));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void decreaseThreadCount(Object ... args) {
        if (args == null) {
            return;
        }
        try {
            int index = 0;
            while (index < args.length) {
                Object arg;
                CacheMap<Object, AtomicInteger> threadCount = this.threadCountMap.get(index);
                if (threadCount != null && (arg = args[index]) != null) {
                    if (Collection.class.isAssignableFrom(arg.getClass())) {
                        for (Object value : (Collection)arg) {
                            int currentValue;
                            AtomicInteger oldValue = threadCount.putIfAbsent(value, new AtomicInteger());
                            if (oldValue == null || (currentValue = oldValue.decrementAndGet()) > 0) continue;
                            threadCount.remove(value);
                        }
                    } else if (arg.getClass().isArray()) {
                        int length = Array.getLength(arg);
                        for (int i = 0; i < length; ++i) {
                            int currentValue;
                            Object value = Array.get(arg, i);
                            AtomicInteger oldValue = threadCount.putIfAbsent(value, new AtomicInteger());
                            if (oldValue == null || (currentValue = oldValue.decrementAndGet()) > 0) continue;
                            threadCount.remove(value);
                        }
                    } else {
                        int currentValue;
                        AtomicInteger oldValue = threadCount.putIfAbsent(arg, new AtomicInteger());
                        if (oldValue != null && (currentValue = oldValue.decrementAndGet()) <= 0) {
                            threadCount.remove(arg);
                        }
                    }
                }
                ++index;
            }
            return;
        }
        catch (Throwable e) {
            RecordLog.warn("[ParameterMetric] Param exception", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addThreadCount(Object ... args) {
        if (args == null) {
            return;
        }
lbl3:
        // 4 sources

        try {
            for (index = 0; index < args.length; ++index) {
                block10: {
                    block9: {
                        threadCount = this.threadCountMap.get(index);
                        if (threadCount == null || (arg = args[index]) == null) continue;
                        if (!Collection.class.isAssignableFrom(arg.getClass())) break block9;
                        for (E value : (Collection)arg) {
                            oldValue = threadCount.putIfAbsent(value, new AtomicInteger());
                            if (oldValue != null) {
                                oldValue.incrementAndGet();
                                continue;
                            }
                            threadCount.put(value, new AtomicInteger(1));
                        }
                        ** GOTO lbl3
                    }
                    if (!arg.getClass().isArray()) break block10;
                    length = Array.getLength(arg);
                    for (i = 0; i < length; ++i) {
                        value = Array.get(arg, i);
                        oldValue = threadCount.putIfAbsent(value, new AtomicInteger());
                        if (oldValue != null) {
                            oldValue.incrementAndGet();
                            continue;
                        }
                        threadCount.put(value, new AtomicInteger(1));
                    }
                    ** GOTO lbl3
                }
                oldValue = threadCount.putIfAbsent(arg, new AtomicInteger());
                if (oldValue != null) {
                    oldValue.incrementAndGet();
                    continue;
                }
                threadCount.put(arg, new AtomicInteger(1));
            }
        }
        catch (Throwable e) {
            RecordLog.warn("[ParameterMetric] Param exception", e);
        }
    }

    public long getThreadCount(int index, Object value) {
        CacheMap<Object, AtomicInteger> cacheMap = this.threadCountMap.get(index);
        if (cacheMap == null) {
            return 0L;
        }
        AtomicInteger count = cacheMap.get(value);
        return count == null ? 0L : (long)count.get();
    }

    Map<ParamFlowRule, CacheMap<Object, AtomicLong>> getRuleTokenCounterMap() {
        return this.ruleTokenCounter;
    }

    Map<Integer, CacheMap<Object, AtomicInteger>> getThreadCountMap() {
        return this.threadCountMap;
    }

    Map<ParamFlowRule, CacheMap<Object, AtomicLong>> getRuleTimeCounterMap() {
        return this.ruleTimeCounters;
    }
}

