/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.statistic.cache;

import com.alibaba.csp.ahas.shaded.com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.alibaba.csp.ahas.shaded.com.googlecode.concurrentlinkedhashmap.Weighers;
import com.alibaba.csp.sentinel.slots.statistic.cache.CacheMap;
import java.util.Set;

public class ConcurrentLinkedHashMapWrapper<T, R>
implements CacheMap<T, R> {
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private final ConcurrentLinkedHashMap<T, R> map;

    public ConcurrentLinkedHashMapWrapper(long size) {
        if (size <= 0L) {
            throw new IllegalArgumentException("Cache max capacity should be positive: " + size);
        }
        this.map = new ConcurrentLinkedHashMap.Builder().concurrencyLevel(16).maximumWeightedCapacity(size).weigher(Weighers.singleton()).build();
    }

    public ConcurrentLinkedHashMapWrapper(ConcurrentLinkedHashMap<T, R> map) {
        if (map == null) {
            throw new IllegalArgumentException("Invalid map instance");
        }
        this.map = map;
    }

    @Override
    public boolean containsKey(T key) {
        return this.map.containsKey(key);
    }

    @Override
    public R get(T key) {
        return this.map.get(key);
    }

    @Override
    public R remove(T key) {
        return this.map.remove(key);
    }

    @Override
    public R put(T key, R value) {
        return this.map.put(key, value);
    }

    @Override
    public R putIfAbsent(T key, R value) {
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public long size() {
        return this.map.weightedSize();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<T> keySet(boolean ascending) {
        if (ascending) {
            return this.map.ascendingKeySet();
        }
        return this.map.descendingKeySet();
    }
}

