/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.system;

import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;

public class SystemStatusListener
implements Runnable {
    private volatile double currentLoad = -1.0;
    private volatile double currentCpuUsage = -1.0;

    public double getSystemAverageLoad() {
        return this.currentLoad;
    }

    public double getCpuUsage() {
        return this.currentCpuUsage;
    }

    @Override
    public void run() {
        try {
            OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
            this.currentLoad = osBean.getSystemLoadAverage();
            this.currentCpuUsage = osBean.getSystemCpuLoad();
            if (this.currentLoad > SystemRuleManager.getSystemLoadThreshold() || this.currentCpuUsage > SystemRuleManager.getCpuUsageThreshold()) {
                this.writeSystemStatusLog();
            }
        }
        catch (Throwable e) {
            RecordLog.warn("[SystemStatusListener] Failed to get system metrics from JMX", e);
        }
    }

    private void writeSystemStatusLog() {
        StringBuilder sb = new StringBuilder();
        sb.append("[SystemStatusListener] Load or CPU usage exceeds the threshold: ");
        sb.append("load:").append(String.format("%.4f", this.currentLoad)).append("; ");
        sb.append("cpuUsage:").append(String.format("%.4f", this.currentCpuUsage)).append("; ");
        sb.append("passQps:").append(String.format("%.4f", Constants.ENTRY_NODE.passQps())).append("; ");
        sb.append("completeQps:").append(String.format("%.4f", Constants.ENTRY_NODE.successQps())).append("; ");
        sb.append("avgRt:").append(String.format("%.4f", Constants.ENTRY_NODE.avgRt())).append("; ");
        sb.append("concurrency:").append(Constants.ENTRY_NODE.curThreadNum()).append("; ");
        sb.append("minRt:").append(String.format("%.2f", Constants.ENTRY_NODE.minRt())).append("; ");
        sb.append("maxCompleteQps:").append(String.format("%.2f", Constants.ENTRY_NODE.maxSuccessQps()));
        RecordLog.info(sb.toString(), new Object[0]);
    }
}

