/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import com.alibaba.csp.ahas.shaded.org.apache.log4j.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.hyperic.sigar.FileInfo;
import org.hyperic.sigar.FileWatcher;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarFileNotFoundException;
import org.hyperic.sigar.SigarLog;

public class ProcFileMirror
extends FileWatcher {
    private String proc;
    private long expire;
    private static final Logger log = SigarLog.getLogger(ProcFileMirror.class.getName());
    private static final boolean isDebug = log.isDebugEnabled();

    public ProcFileMirror(Sigar sigar, String proc) {
        super(sigar);
        this.proc = proc;
        this.expire = 300000L;
    }

    public long getExpireMillis() {
        return this.expire;
    }

    public void setExpire(long seconds) {
        this.setExpireMillis(seconds * 1000L);
    }

    public void setExpireMillis(long millis) {
        this.expire = millis;
    }

    public String getProcFile(File file) {
        return this.getProcFile(file.getPath());
    }

    public String getProcFile(String file) {
        String PROC = "/proc/";
        if (file.startsWith("/proc/")) {
            file = file.substring("/proc/".length());
        }
        return this.proc + File.separator + file;
    }

    private void mirror(String source) throws IOException {
        this.mirror(source, this.getProcFile(source));
    }

    private String mirrorToString(File source, File dest) {
        return "mirror(" + source + ", " + dest + ")";
    }

    private void mirror(String source, String dest) throws IOException {
        this.mirror(new File(source), new File(dest));
    }

    private void mirror(File source, File dest) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            int nread;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[2048];
            while ((nread = is.read(buffer)) != -1) {
                os.write(buffer, 0, nread);
            }
        }
        catch (IOException e) {
            String msg = this.mirrorToString(source, dest) + " failed: " + e.getMessage();
            throw new IOException(msg);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (os != null) {
                os.close();
            }
        }
        if (isDebug) {
            log.debug(this.mirrorToString(source, dest));
        }
    }

    public FileInfo add(String name) throws SigarException {
        File source = new File(name);
        File dest = new File(this.getProcFile(source));
        File dir = dest.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            String msg = "mkdir(" + dir + ") failed";
            throw new SigarException(msg);
        }
        if (!source.canRead()) {
            throw new SigarException("Cannot read: " + source);
        }
        if (dest.isFile() && !dest.canWrite() || !dir.isDirectory() || !dir.canWrite()) {
            throw new SigarException("Cannot write: " + dest);
        }
        try {
            this.mirror(source.getPath(), dest.getPath());
        }
        catch (IOException e) {
            throw new SigarException(e.getMessage());
        }
        return super.add(source.getPath());
    }

    public void onChange(FileInfo info) {
        try {
            this.mirror(info.getName());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    protected boolean changed(FileInfo info) throws SigarException, SigarFileNotFoundException {
        File dest = new File(this.getProcFile(info.getName()));
        long now = System.currentTimeMillis();
        return now - dest.lastModified() > this.expire;
    }
}

