/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.annotation.aspectj;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.csp.sentinel.annotation.aspectj.MethodWrapper;
import com.alibaba.csp.sentinel.annotation.aspectj.ResourceMetadataRegistry;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.util.MethodUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class SentinelResourceAspect {
    private final Logger logger = LoggerFactory.getLogger(SentinelResourceAspect.class);

    @Pointcut(value="@annotation(com.alibaba.csp.sentinel.annotation.SentinelResource)")
    public void sentinelResourceAnnotationPointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="sentinelResourceAnnotationPointcut()")
    public Object invokeResourceWithSentinel(ProceedingJoinPoint pjp) throws Throwable {
        Method originMethod = this.resolveMethod(pjp);
        SentinelResource annotation = originMethod.getAnnotation(SentinelResource.class);
        if (annotation == null) {
            throw new IllegalStateException("Wrong state for SentinelResource annotation");
        }
        String resourceName = this.getResourceName(annotation.value(), originMethod);
        EntryType entryType = annotation.entryType();
        Entry entry = null;
        try {
            Object result;
            ContextUtil.enter((String)resourceName);
            entry = SphU.entry((String)resourceName, (EntryType)entryType);
            Object object = result = pjp.proceed();
            return object;
        }
        catch (BlockException ex) {
            Object object = this.handleBlockException(pjp, annotation, ex);
            return object;
        }
        finally {
            if (entry != null) {
                entry.exit();
            }
            ContextUtil.exit();
        }
    }

    private String getResourceName(String resourceName, Method method) {
        if (StringUtil.isNotBlank((String)resourceName)) {
            return resourceName;
        }
        return MethodUtil.resolveMethodName((Method)method);
    }

    private Object handleBlockException(ProceedingJoinPoint pjp, SentinelResource annotation, BlockException ex) throws Exception {
        Method method;
        Object[] originArgs = pjp.getArgs();
        if (this.isDegradeFailure(ex) && (method = this.extractFallbackMethod(pjp, annotation.fallback())) != null) {
            return method.invoke(pjp.getTarget(), originArgs);
        }
        Method blockHandler = this.extractBlockHandlerMethod(pjp, annotation.blockHandler(), annotation.blockHandlerClass());
        if (blockHandler != null) {
            Object[] args = Arrays.copyOf(originArgs, originArgs.length + 1);
            args[args.length - 1] = ex;
            if (this.isStatic(blockHandler)) {
                return blockHandler.invoke(null, args);
            }
            return blockHandler.invoke(pjp.getTarget(), args);
        }
        throw ex;
    }

    private boolean isDegradeFailure(BlockException ex) {
        return ex instanceof DegradeException;
    }

    private Method extractFallbackMethod(ProceedingJoinPoint pjp, String fallbackName) {
        if (StringUtil.isBlank((String)fallbackName)) {
            return null;
        }
        Class<?> clazz = pjp.getTarget().getClass();
        MethodWrapper m = ResourceMetadataRegistry.lookupFallback(clazz, fallbackName);
        if (m == null) {
            Method method = this.resolveFallbackInternal(pjp, fallbackName);
            ResourceMetadataRegistry.updateFallbackFor(clazz, fallbackName, method);
            return method;
        }
        if (!m.isPresent()) {
            return null;
        }
        return m.getMethod();
    }

    private Method resolveFallbackInternal(ProceedingJoinPoint pjp, String name) {
        Method originMethod = this.resolveMethod(pjp);
        Class<?>[] parameterTypes = originMethod.getParameterTypes();
        return this.findMethod(false, pjp.getTarget().getClass(), name, originMethod.getReturnType(), parameterTypes);
    }

    private Method extractBlockHandlerMethod(ProceedingJoinPoint pjp, String name, Class<?>[] locationClass) {
        if (StringUtil.isBlank((String)name)) {
            return null;
        }
        boolean mustStatic = locationClass != null && locationClass.length >= 1;
        Class<?> clazz = mustStatic ? locationClass[0] : pjp.getTarget().getClass();
        MethodWrapper m = ResourceMetadataRegistry.lookupBlockHandler(clazz, name);
        if (m == null) {
            Method method = this.resolveBlockHandlerInternal(pjp, name, clazz, mustStatic);
            ResourceMetadataRegistry.updateBlockHandlerFor(clazz, name, method);
            return method;
        }
        if (!m.isPresent()) {
            return null;
        }
        return m.getMethod();
    }

    private Method resolveBlockHandlerInternal(ProceedingJoinPoint pjp, String name, Class<?> clazz, boolean mustStatic) {
        Method originMethod = this.resolveMethod(pjp);
        Class<?>[] originList = originMethod.getParameterTypes();
        Class<?>[] parameterTypes = Arrays.copyOf(originList, originList.length + 1);
        parameterTypes[parameterTypes.length - 1] = BlockException.class;
        return this.findMethod(mustStatic, clazz, name, originMethod.getReturnType(), parameterTypes);
    }

    private boolean checkStatic(boolean mustStatic, Method method) {
        return !mustStatic || this.isStatic(method);
    }

    private Method findMethod(boolean mustStatic, Class<?> clazz, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!name.equals(method.getName()) || !this.checkStatic(mustStatic, method) || !returnType.isAssignableFrom(method.getReturnType()) || !Arrays.equals(parameterTypes, method.getParameterTypes())) continue;
            this.logger.info("Resolved method [{}] in class [{}]", (Object)name, (Object)clazz.getCanonicalName());
            return method;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            return this.findMethod(mustStatic, superClass, name, returnType, parameterTypes);
        }
        String methodType = mustStatic ? " static" : "";
        this.logger.error("Cannot find{} method [{}] in class [{}] with parameters {}", new Object[]{methodType, name, clazz.getCanonicalName(), Arrays.toString(parameterTypes)});
        return null;
    }

    private boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    private Method resolveMethod(ProceedingJoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Class<?> targetClass = joinPoint.getTarget().getClass();
        Method method = this.getDeclaredMethodFor(targetClass, signature.getName(), signature.getMethod().getParameterTypes());
        if (method == null) {
            throw new IllegalStateException("Cannot resolve target method: " + signature.getMethod().getName());
        }
        return method;
    }

    private Method getDeclaredMethodFor(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getDeclaredMethodFor(superClass, name, parameterTypes);
            }
            return null;
        }
    }
}

