/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.dubbo;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.dubbo.DubboUtils;
import com.alibaba.csp.sentinel.adapter.dubbo.fallback.DubboFallbackRegistry;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider"})
public class SentinelDubboProviderFilter
implements Filter {
    public SentinelDubboProviderFilter() {
        RecordLog.info((String)"Sentinel Apache Dubbo provider filter initialized", (Object[])new Object[0]);
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String application = DubboUtils.getApplication(invocation, "");
        Entry interfaceEntry = null;
        Entry methodEntry = null;
        try {
            String resourceName = DubboUtils.getResourceName(invoker, invocation);
            String interfaceName = invoker.getInterface().getName();
            ContextUtil.enter((String)resourceName, (String)application);
            interfaceEntry = SphU.entry((String)interfaceName, (EntryType)EntryType.IN);
            methodEntry = SphU.entry((String)resourceName, (EntryType)EntryType.IN, (int)1, (Object[])invocation.getArguments());
            Result result = invoker.invoke(invocation);
            if (result.hasException()) {
                Throwable e = result.getException();
                Tracer.traceEntry((Throwable)e, (Entry)interfaceEntry);
                Tracer.traceEntry((Throwable)e, (Entry)methodEntry);
            }
            Result result2 = result;
            return result2;
        }
        catch (BlockException e) {
            Result result = DubboFallbackRegistry.getProviderFallback().handle(invoker, invocation, e);
            return result;
        }
        catch (RpcException e) {
            Tracer.traceEntry((Throwable)e, interfaceEntry);
            Tracer.traceEntry((Throwable)e, methodEntry);
            throw e;
        }
        finally {
            if (methodEntry != null) {
                methodEntry.exit(1, invocation.getArguments());
            }
            if (interfaceEntry != null) {
                interfaceEntry.exit();
            }
            ContextUtil.exit();
        }
    }
}

