/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.dubbo;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.adapter.dubbo.BaseSentinelDubboFilter;
import com.alibaba.csp.sentinel.adapter.dubbo.DubboUtils;
import com.alibaba.csp.sentinel.adapter.dubbo.config.DubboConfig;
import com.alibaba.csp.sentinel.adapter.dubbo.fallback.DubboFallbackRegistry;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvokeMode;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.support.RpcUtils;

@Activate(group={"consumer"})
public class SentinelDubboConsumerFilter
extends BaseSentinelDubboFilter {
    public SentinelDubboConsumerFilter() {
        RecordLog.info((String)"Sentinel Apache Dubbo consumer filter initialized", (Object[])new Object[0]);
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Entry interfaceEntry = null;
        Entry methodEntry = null;
        RpcContext rpcContext = RpcContext.getContext();
        try {
            String methodResourceName = DubboUtils.getResourceName(invoker, invocation, DubboConfig.getDubboConsumerPrefix());
            String interfaceResourceName = DubboConfig.getDubboInterfaceGroupAndVersionEnabled() != false ? invoker.getUrl().getColonSeparatedKey() : invoker.getInterface().getName();
            InvokeMode invokeMode = RpcUtils.getInvokeMode((URL)invoker.getUrl(), (Invocation)invocation);
            if (InvokeMode.SYNC == invokeMode) {
                interfaceEntry = SphU.entry((String)interfaceResourceName, (int)2, (EntryType)EntryType.OUT);
                rpcContext.set("dubboInterfaceEntry", (Object)interfaceEntry);
                methodEntry = SphU.entry((String)methodResourceName, (int)2, (EntryType)EntryType.OUT, (Object[])invocation.getArguments());
            } else {
                interfaceEntry = SphU.asyncEntry((String)interfaceResourceName, (int)2, (EntryType)EntryType.OUT);
                rpcContext.set("dubboInterfaceEntry", (Object)interfaceEntry);
                methodEntry = SphU.asyncEntry((String)methodResourceName, (int)2, (EntryType)EntryType.OUT, (int)1, (Object[])invocation.getArguments());
            }
            rpcContext.set("dubboMethodEntry", (Object)methodEntry);
            return invoker.invoke(invocation);
        }
        catch (BlockException e) {
            return DubboFallbackRegistry.getConsumerFallback().handle(invoker, invocation, e);
        }
    }
}

