/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.dubbo;

import com.alibaba.csp.sentinel.adapter.dubbo.config.DubboAdapterGlobalConfig;
import com.alibaba.csp.sentinel.util.StringUtil;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;

public final class DubboUtils {
    public static final String SENTINEL_DUBBO_APPLICATION_KEY = "dubboApplication";

    public static String getApplication(Invocation invocation, String defaultValue) {
        if (invocation == null || invocation.getAttachments() == null) {
            throw new IllegalArgumentException("Bad invocation instance");
        }
        return invocation.getAttachment(SENTINEL_DUBBO_APPLICATION_KEY, defaultValue);
    }

    public static String getMethodResourceName(Invoker<?> invoker, Invocation invocation) {
        return DubboUtils.getMethodResourceName(invoker, invocation, false);
    }

    public static String getMethodResourceName(Invoker<?> invoker, Invocation invocation, Boolean useGroupAndVersion) {
        StringBuilder buf = new StringBuilder(64);
        String interfaceResource = useGroupAndVersion != false ? invoker.getUrl().getColonSeparatedKey() : invoker.getInterface().getName();
        buf.append(interfaceResource).append(":").append(invocation.getMethodName()).append("(");
        boolean isFirst = true;
        for (Class clazz : invocation.getParameterTypes()) {
            if (!isFirst) {
                buf.append(",");
            }
            buf.append(clazz.getName());
            isFirst = false;
        }
        buf.append(")");
        return buf.toString();
    }

    public static String getMethodResourceName(Invoker<?> invoker, Invocation invocation, String prefix) {
        if (StringUtil.isNotBlank((String)prefix)) {
            return new StringBuilder(64).append(prefix).append(DubboUtils.getMethodResourceName(invoker, invocation, DubboAdapterGlobalConfig.getDubboInterfaceGroupAndVersionEnabled())).toString();
        }
        return DubboUtils.getMethodResourceName(invoker, invocation, DubboAdapterGlobalConfig.getDubboInterfaceGroupAndVersionEnabled());
    }

    public static String getInterfaceName(Invoker invoker) {
        return DubboUtils.getInterfaceName(invoker, false);
    }

    public static String getInterfaceName(Invoker<?> invoker, Boolean useGroupAndVersion) {
        StringBuilder buf = new StringBuilder(64);
        return useGroupAndVersion != false ? invoker.getUrl().getColonSeparatedKey() : invoker.getInterface().getName();
    }

    public static String getInterfaceName(Invoker<?> invoker, String prefix) {
        if (StringUtil.isNotBlank((String)prefix)) {
            return new StringBuilder(64).append(prefix).append(DubboUtils.getInterfaceName(invoker, DubboAdapterGlobalConfig.getDubboInterfaceGroupAndVersionEnabled())).toString();
        }
        return DubboUtils.getInterfaceName(invoker, DubboAdapterGlobalConfig.getDubboInterfaceGroupAndVersionEnabled());
    }

    private DubboUtils() {
    }
}

