/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.dubbo3;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.dubbo3.BaseSentinelDubboFilter;
import com.alibaba.csp.sentinel.adapter.dubbo3.DubboUtils;
import com.alibaba.csp.sentinel.adapter.dubbo3.config.DubboAdapterGlobalConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvokeMode;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;
import org.apache.dubbo.rpc.support.RpcUtils;

@Activate(group={"consumer"})
public class SentinelDubboConsumerFilter
extends BaseSentinelDubboFilter
implements ClusterFilter {
    public SentinelDubboConsumerFilter() {
        RecordLog.info((String)"Sentinel Apache Dubbo3 consumer filter initialized", (Object[])new Object[0]);
    }

    @Override
    String getMethodName(Invoker invoker, Invocation invocation, String prefix) {
        return DubboUtils.getMethodResourceName(invoker, invocation, prefix);
    }

    @Override
    String getInterfaceName(Invoker invoker, String prefix) {
        return DubboUtils.getInterfaceName(invoker, prefix);
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        InvokeMode invokeMode = RpcUtils.getInvokeMode((URL)invoker.getUrl(), (Invocation)invocation);
        if (InvokeMode.SYNC == invokeMode) {
            return this.syncInvoke(invoker, invocation);
        }
        return this.asyncInvoke(invoker, invocation);
    }

    private Result syncInvoke(Invoker<?> invoker, Invocation invocation) {
        Entry interfaceEntry = null;
        Entry methodEntry = null;
        String prefix = DubboAdapterGlobalConfig.getDubboConsumerResNamePrefixKey();
        String interfaceResourceName = this.getInterfaceName(invoker, prefix);
        String methodResourceName = this.getMethodName(invoker, invocation, prefix);
        try {
            interfaceEntry = SphU.entry((String)interfaceResourceName, (int)2, (EntryType)EntryType.OUT);
            methodEntry = SphU.entry((String)methodResourceName, (int)2, (EntryType)EntryType.OUT, (Object[])invocation.getArguments());
            Result result = invoker.invoke(invocation);
            if (result.hasException()) {
                Tracer.traceEntry((Throwable)result.getException(), (Entry)interfaceEntry);
                Tracer.traceEntry((Throwable)result.getException(), (Entry)methodEntry);
            }
            Result result2 = result;
            return result2;
        }
        catch (BlockException e) {
            Result result = DubboAdapterGlobalConfig.getConsumerFallback().handle(invoker, invocation, e);
            return result;
        }
        catch (RpcException e) {
            Tracer.traceEntry((Throwable)e, (Entry)interfaceEntry);
            Tracer.traceEntry((Throwable)e, methodEntry);
            throw e;
        }
        finally {
            if (methodEntry != null) {
                methodEntry.exit(1, invocation.getArguments());
            }
            if (interfaceEntry != null) {
                interfaceEntry.exit();
            }
        }
    }

    private Result asyncInvoke(Invoker<?> invoker, Invocation invocation) {
        LinkedList<EntryHolder> queue = new LinkedList<EntryHolder>();
        String prefix = DubboAdapterGlobalConfig.getDubboConsumerResNamePrefixKey();
        String interfaceResourceName = this.getInterfaceName(invoker, prefix);
        String methodResourceName = this.getMethodName(invoker, invocation, prefix);
        try {
            queue.push(new EntryHolder((Entry)SphU.asyncEntry((String)interfaceResourceName, (int)2, (EntryType)EntryType.OUT), null));
            queue.push(new EntryHolder((Entry)SphU.asyncEntry((String)methodResourceName, (int)2, (EntryType)EntryType.OUT, (int)1, (Object[])invocation.getArguments()), invocation.getArguments()));
            Result result = invoker.invoke(invocation);
            result.whenCompleteWithContext((r, throwable) -> {
                Throwable error = throwable;
                if (error == null) {
                    error = Optional.ofNullable(r).map(Result::getException).orElse(null);
                }
                while (!queue.isEmpty()) {
                    EntryHolder holder = (EntryHolder)queue.pop();
                    Tracer.traceEntry((Throwable)error, (Entry)holder.entry);
                    this.exitEntry(holder);
                }
            });
            return result;
        }
        catch (BlockException e) {
            while (!queue.isEmpty()) {
                this.exitEntry((EntryHolder)queue.pop());
            }
            return DubboAdapterGlobalConfig.getConsumerFallback().handle(invoker, invocation, e);
        }
    }

    private void exitEntry(EntryHolder holder) {
        if (holder.params != null) {
            holder.entry.exit(1, holder.params);
        } else {
            holder.entry.exit();
        }
    }

    static class EntryHolder {
        private final Entry entry;
        private final Object[] params;

        public EntryHolder(Entry entry, Object[] params) {
            this.entry = entry;
            this.params = params;
        }
    }
}

