/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.config;

import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ServerChangeObserver;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public final class ClusterClientConfigManager {
    private static volatile String serverHost = null;
    private static volatile int serverPort = 8730;
    private static volatile int requestTimeout = 20;
    private static final PropertyListener<ClusterClientConfig> PROPERTY_LISTENER = new ClientConfigPropertyListener();
    private static SentinelProperty<ClusterClientConfig> currentProperty = new DynamicSentinelProperty();
    private static final List<ServerChangeObserver> SERVER_CHANGE_OBSERVERS = new ArrayList<ServerChangeObserver>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<ClusterClientConfig> property) {
        PropertyListener<ClusterClientConfig> propertyListener = PROPERTY_LISTENER;
        synchronized (propertyListener) {
            RecordLog.info((String)"[ClusterClientConfigManager] Registering new property to cluster client config manager", (Object[])new Object[0]);
            currentProperty.removeListener(PROPERTY_LISTENER);
            property.addListener(PROPERTY_LISTENER);
            currentProperty = property;
        }
    }

    public static void addServerChangeObserver(ServerChangeObserver observer) {
        AssertUtil.notNull((Object)observer, (String)"observer cannot be null");
        SERVER_CHANGE_OBSERVERS.add(observer);
    }

    public static void applyNewConfig(ClusterClientConfig config) {
        currentProperty.updateValue((Object)config);
    }

    public static boolean isValidConfig(ClusterClientConfig config) {
        return config != null && StringUtil.isNotBlank((String)config.getServerHost()) && config.getServerPort() > 0 && config.getServerPort() <= 65535 && config.getRequestTimeout() > 0;
    }

    public static void updateServer(ClusterClientConfig config) {
        String host = config.getServerHost();
        int port = config.getServerPort();
        AssertUtil.assertNotBlank((String)host, (String)"token server host cannot be empty");
        AssertUtil.isTrue((port > 0 ? 1 : 0) != 0, (String)"token server port should be valid (positive)");
        if (serverPort == port && host.equals(serverHost)) {
            return;
        }
        for (ServerChangeObserver observer : SERVER_CHANGE_OBSERVERS) {
            observer.onRemoteServerChange(config);
        }
        serverHost = host;
        serverPort = port;
    }

    public static String getServerHost() {
        return serverHost;
    }

    public static int getServerPort() {
        return serverPort;
    }

    public static int getRequestTimeout() {
        return requestTimeout;
    }

    private ClusterClientConfigManager() {
    }

    static {
        currentProperty.addListener(PROPERTY_LISTENER);
    }

    private static class ClientConfigPropertyListener
    implements PropertyListener<ClusterClientConfig> {
        private ClientConfigPropertyListener() {
        }

        public void configUpdate(ClusterClientConfig config) {
            this.applyConfig(config);
        }

        public void configLoad(ClusterClientConfig config) {
            if (config == null) {
                RecordLog.warn((String)"[ClusterClientConfigManager] Empty initial config", (Object[])new Object[0]);
                return;
            }
            this.applyConfig(config);
        }

        private synchronized void applyConfig(ClusterClientConfig config) {
            if (!ClusterClientConfigManager.isValidConfig(config)) {
                RecordLog.warn((String)("[ClusterClientConfigManager] Invalid cluster client config, ignoring: " + config), (Object[])new Object[0]);
                return;
            }
            RecordLog.info((String)("[ClusterClientConfigManager] Updating new config: " + config), (Object[])new Object[0]);
            if (config.getRequestTimeout() != requestTimeout) {
                requestTimeout = config.getRequestTimeout();
            }
            ClusterClientConfigManager.updateServer(config);
        }
    }
}

