/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow;

import com.alibaba.csp.sentinel.cluster.TokenResult;
import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterParamFlowRuleManager;
import com.alibaba.csp.sentinel.cluster.flow.statistic.ClusterParamMetricStatistics;
import com.alibaba.csp.sentinel.cluster.flow.statistic.metric.ClusterParamMetric;
import com.alibaba.csp.sentinel.cluster.server.log.ClusterServerStatLogUtil;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import java.util.Collection;

public final class ClusterParamFlowChecker {
    static TokenResult acquireClusterToken(ParamFlowRule rule, int count, Collection<Object> values) {
        Long id = rule.getClusterConfig().getFlowId();
        ClusterParamMetric metric = ClusterParamMetricStatistics.getMetric(id);
        if (metric == null) {
            return new TokenResult(Integer.valueOf(-1));
        }
        double remaining = -1.0;
        boolean hasPassed = true;
        Object blockObject = null;
        for (Object value : values) {
            double nextRemaining;
            double latestQps = metric.getAvg(value);
            double threshold = ClusterParamFlowChecker.calcGlobalThreshold(rule, value);
            remaining = nextRemaining = threshold - latestQps - (double)count;
            if (!(nextRemaining < 0.0)) continue;
            hasPassed = false;
            blockObject = value;
            break;
        }
        if (hasPassed) {
            for (Object value : values) {
                metric.addValue(value, count);
            }
            ClusterServerStatLogUtil.log(String.format("param|pass|%d", id));
        } else {
            ClusterServerStatLogUtil.log(String.format("param|block|%d|%s", id, blockObject));
        }
        if (values.size() > 1) {
            remaining = -1.0;
        }
        return hasPassed ? ClusterParamFlowChecker.newPassResponse((int)remaining) : ClusterParamFlowChecker.newBlockResponse();
    }

    private static TokenResult newPassResponse(int remaining) {
        return new TokenResult(Integer.valueOf(0)).setRemaining(remaining).setWaitInMs(0);
    }

    private static TokenResult newBlockResponse() {
        return new TokenResult(Integer.valueOf(1)).setRemaining(0).setWaitInMs(0);
    }

    private static double calcGlobalThreshold(ParamFlowRule rule, Object value) {
        double count = ClusterParamFlowChecker.getRawThreshold(rule, value);
        switch (rule.getClusterConfig().getThresholdType()) {
            case 1: {
                return count;
            }
        }
        int connectedCount = ClusterParamFlowRuleManager.getConnectedCount(rule.getClusterConfig().getFlowId());
        return count * (double)connectedCount;
    }

    private static double getRawThreshold(ParamFlowRule rule, Object value) {
        Integer itemCount = rule.retrieveExclusiveItemCount(value);
        if (itemCount == null) {
            return rule.getCount();
        }
        return itemCount.intValue();
    }

    private ClusterParamFlowChecker() {
    }
}

