/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.command.handler;

import com.alibaba.csp.sentinel.cluster.server.config.ClusterServerConfigManager;
import com.alibaba.csp.sentinel.cluster.server.config.ServerFlowConfig;
import com.alibaba.csp.sentinel.cluster.server.config.ServerTransportConfig;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSONObject;

@CommandMapping(name="cluster/server/fetchConfig")
public class FetchClusterServerConfigHandler
implements CommandHandler<String> {
    public CommandResponse<String> handle(CommandRequest request) {
        String namespace = request.getParam("namespace");
        if (StringUtil.isEmpty((String)namespace)) {
            return this.globalConfigResult();
        }
        return this.namespaceConfigResult(namespace);
    }

    private CommandResponse<String> namespaceConfigResult(String namespace) {
        ServerFlowConfig flowConfig = new ServerFlowConfig().setExceedCount(ClusterServerConfigManager.getExceedCount(namespace)).setMaxOccupyRatio(ClusterServerConfigManager.getMaxOccupyRatio(namespace)).setIntervalMs(ClusterServerConfigManager.getIntervalMs(namespace)).setSampleCount(ClusterServerConfigManager.getSampleCount(namespace));
        JSONObject config = new JSONObject().fluentPut("flow", (Object)flowConfig);
        return CommandResponse.ofSuccess((Object)config.toJSONString());
    }

    private CommandResponse<String> globalConfigResult() {
        ServerTransportConfig transportConfig = new ServerTransportConfig().setPort(ClusterServerConfigManager.getPort()).setIdleSeconds(ClusterServerConfigManager.getIdleSeconds());
        ServerFlowConfig flowConfig = new ServerFlowConfig().setExceedCount(ClusterServerConfigManager.getExceedCount()).setMaxOccupyRatio(ClusterServerConfigManager.getMaxOccupyRatio()).setIntervalMs(ClusterServerConfigManager.getIntervalMs()).setSampleCount(ClusterServerConfigManager.getSampleCount());
        JSONObject config = new JSONObject().fluentPut("transport", (Object)transportConfig).fluentPut("flow", (Object)flowConfig).fluentPut("namespaceSet", ClusterServerConfigManager.getNamespaceSet());
        return CommandResponse.ofSuccess((Object)config.toJSONString());
    }
}

