/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.command.handler;

import com.alibaba.csp.sentinel.cluster.server.config.ClusterServerConfigManager;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.net.URLDecoder;
import java.util.Set;

@CommandMapping(name="cluster/server/modifyNamespaceSet")
public class ModifyServerNamespaceSetHandler
implements CommandHandler<String> {
    public CommandResponse<String> handle(CommandRequest request) {
        String data = request.getParam("data");
        if (StringUtil.isBlank((String)data)) {
            return CommandResponse.ofFailure((Throwable)new IllegalArgumentException("empty data"));
        }
        try {
            data = URLDecoder.decode(data, "utf-8");
            RecordLog.info((String)("[ModifyServerNamespaceSetHandler] Receiving cluster server namespace set: " + data), (Object[])new Object[0]);
            Set set = (Set)JSON.parseObject((String)data, (TypeReference)new TypeReference<Set<String>>(){}, (Feature[])new Feature[0]);
            ClusterServerConfigManager.loadServerNamespaceSet(set);
            return CommandResponse.ofSuccess((Object)"success");
        }
        catch (Exception e) {
            RecordLog.warn((String)"[ModifyServerNamespaceSetHandler] Decode cluster server namespace set error", (Throwable)e);
            return CommandResponse.ofFailure((Throwable)e, (Object)"decode client cluster config error");
        }
    }
}

