/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.context;

import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.context.ContextNameDefineException;
import com.alibaba.csp.sentinel.context.NullContext;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.node.EntranceNode;
import com.alibaba.csp.sentinel.slotchain.StringResourceWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class ContextUtil {
    private static ThreadLocal<Context> contextHolder = new ThreadLocal();
    private static volatile Map<String, DefaultNode> contextNameNodeMap = new HashMap<String, DefaultNode>();
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final Context NULL_CONTEXT = new NullContext();

    public static Context enter(String name, String origin) {
        if ("default_context_name".equals(name)) {
            throw new ContextNameDefineException("The default_context_name can't be permit to defined!");
        }
        return ContextUtil.trueEnter(name, origin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Context trueEnter(String name, String origin) {
        Context context = contextHolder.get();
        if (context == null) {
            Map<String, DefaultNode> localCacheNameMap = contextNameNodeMap;
            DefaultNode node = localCacheNameMap.get(name);
            if (node == null) {
                if (localCacheNameMap.size() > 2000) {
                    return NULL_CONTEXT;
                }
                try {
                    LOCK.lock();
                    node = contextNameNodeMap.get(name);
                    if (node == null) {
                        if (contextNameNodeMap.size() > 2000) {
                            Context context2 = NULL_CONTEXT;
                            return context2;
                        }
                        node = new EntranceNode(new StringResourceWrapper(name, EntryType.IN), null);
                        Constants.ROOT.addChild(node);
                        HashMap<String, DefaultNode> newMap = new HashMap<String, DefaultNode>(contextNameNodeMap.size() + 1);
                        newMap.putAll(contextNameNodeMap);
                        newMap.put(name, node);
                        contextNameNodeMap = newMap;
                    }
                }
                finally {
                    LOCK.unlock();
                }
            }
            context = new Context(node, name);
            context.setOrigin(origin);
            contextHolder.set(context);
        }
        return context;
    }

    public static Context enter(String name) {
        return ContextUtil.enter(name, "");
    }

    public static void exit() {
        Context context = contextHolder.get();
        if (context != null && context.getCurEntry() == null) {
            contextHolder.set(null);
        }
    }

    public static Context getContext() {
        return contextHolder.get();
    }
}

