/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;

public class IntervalProperty {
    public static volatile int INTERVAL = 1;

    public static void init(SentinelProperty<Integer> dataSource) {
        dataSource.addListener(new FlowIntervalPropertyListener());
    }

    private static class FlowIntervalPropertyListener
    implements PropertyListener<Integer> {
        private FlowIntervalPropertyListener() {
        }

        @Override
        public void configUpdate(Integer value) {
            if (value == null) {
                value = 1;
            }
            INTERVAL = value;
            RecordLog.info("Init flow interval: " + INTERVAL);
        }

        @Override
        public void configLoad(Integer value) {
            if (value == null) {
                value = 1;
            }
            INTERVAL = value;
            for (ClusterNode node : ClusterBuilderSlot.getClusterNodeMap().values()) {
                node.reset();
            }
            RecordLog.info("Flow interval change received: " + INTERVAL);
        }
    }
}

