/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node;

import com.alibaba.csp.sentinel.node.IntervalProperty;
import com.alibaba.csp.sentinel.node.Node;
import com.alibaba.csp.sentinel.node.SampleCountProperty;
import com.alibaba.csp.sentinel.node.metric.MetricNode;
import com.alibaba.csp.sentinel.slots.statistic.metric.ArrayMetric;
import com.alibaba.csp.sentinel.slots.statistic.metric.Metric;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class StatisticNode
implements Node {
    private transient Metric rollingCounterInSecond = new ArrayMetric(1000 / SampleCountProperty.sampleCount, IntervalProperty.INTERVAL);
    private transient Metric rollingCounterInMinute = new ArrayMetric(1000, 120);
    private AtomicInteger curThreadNum = new AtomicInteger(0);
    private long lastFetchTime = -1L;

    @Override
    public Map<Long, MetricNode> metrics() {
        long currentTime = TimeUtil.currentTimeMillis();
        currentTime -= currentTime % 1000L;
        ConcurrentHashMap<Long, MetricNode> metrics = new ConcurrentHashMap<Long, MetricNode>();
        List<MetricNode> minutes = this.rollingCounterInMinute.details();
        for (MetricNode node : minutes) {
            if (node.getTimestamp() <= this.lastFetchTime || node.getTimestamp() >= currentTime || node.getPassedQps() == 0L && node.getBlockedQps() == 0L) continue;
            metrics.put(node.getTimestamp(), node);
            this.lastFetchTime = node.getTimestamp();
        }
        return metrics;
    }

    @Override
    public void reset() {
        this.rollingCounterInSecond = new ArrayMetric(1000 / SampleCountProperty.sampleCount, IntervalProperty.INTERVAL);
    }

    @Override
    public long totalRequest() {
        long totalRequest = this.rollingCounterInMinute.pass() + this.rollingCounterInMinute.block();
        return totalRequest / 2L;
    }

    @Override
    public long blockedRequest() {
        return this.rollingCounterInMinute.block() / 2L;
    }

    @Override
    public long blockedQps() {
        return this.rollingCounterInSecond.block() / (long)IntervalProperty.INTERVAL;
    }

    @Override
    public long previousBlockQps() {
        return this.rollingCounterInMinute.previousWindowBlock();
    }

    @Override
    public long previousPassQps() {
        return this.rollingCounterInMinute.previousWindowPass();
    }

    @Override
    public long totalQps() {
        return this.passQps() + this.blockedQps();
    }

    @Override
    public long totalSuccess() {
        return this.rollingCounterInMinute.success() / 2L;
    }

    @Override
    public long exceptionQps() {
        return this.rollingCounterInSecond.exception() / (long)IntervalProperty.INTERVAL;
    }

    @Override
    public long totalException() {
        return this.rollingCounterInMinute.exception() / 2L;
    }

    @Override
    public long passQps() {
        return this.rollingCounterInSecond.pass() / (long)IntervalProperty.INTERVAL;
    }

    @Override
    public long successQps() {
        return this.rollingCounterInSecond.success() / (long)IntervalProperty.INTERVAL;
    }

    @Override
    public long maxSuccessQps() {
        return this.rollingCounterInSecond.maxSuccess() * (long)SampleCountProperty.sampleCount;
    }

    @Override
    public long avgRt() {
        long successCount = this.rollingCounterInSecond.success();
        if (successCount == 0L) {
            return 0L;
        }
        return this.rollingCounterInSecond.rt() / successCount;
    }

    @Override
    public long minRt() {
        return this.rollingCounterInSecond.minRt();
    }

    @Override
    public int curThreadNum() {
        return this.curThreadNum.get();
    }

    @Override
    public void addPassRequest() {
        this.rollingCounterInSecond.addPass();
        this.rollingCounterInMinute.addPass();
    }

    @Override
    public void rt(long rt) {
        this.rollingCounterInSecond.addSuccess();
        this.rollingCounterInSecond.addRT(rt);
        this.rollingCounterInMinute.addSuccess();
        this.rollingCounterInMinute.addRT(rt);
    }

    @Override
    public void increaseBlockedQps() {
        this.rollingCounterInSecond.addBlock();
        this.rollingCounterInMinute.addBlock();
    }

    @Override
    public void increaseExceptionQps() {
        this.rollingCounterInSecond.addException();
        this.rollingCounterInMinute.addException();
    }

    @Override
    public void increaseThreadNum() {
        this.curThreadNum.incrementAndGet();
    }

    @Override
    public void decreaseThreadNum() {
        this.curThreadNum.decrementAndGet();
    }

    @Override
    public void debug() {
        this.rollingCounterInSecond.debugQps();
    }
}

