/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node.metric;

import java.text.SimpleDateFormat;
import java.util.Date;

public class MetricNode {
    private long timestamp;
    private long passedQps;
    private long blockedQps;
    private long successQps;
    private long exception;
    private long rt;
    private String name;

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getSuccessQps() {
        return this.successQps;
    }

    public void setSuccessQps(long successQps) {
        this.successQps = successQps;
    }

    public long getPassedQps() {
        return this.passedQps;
    }

    public void setPassedQps(long passedQps) {
        this.passedQps = passedQps;
    }

    public long getException() {
        return this.exception;
    }

    public void setException(long exception) {
        this.exception = exception;
    }

    public long getBlockedQps() {
        return this.blockedQps;
    }

    public void setBlockedQps(long blockedQps) {
        this.blockedQps = blockedQps;
    }

    public long getRt() {
        return this.rt;
    }

    public void setRt(long rt) {
        this.rt = rt;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "MetricNode{timestamp=" + this.timestamp + ", passedQps=" + this.passedQps + ", blockedQs=" + this.blockedQps + ", successQps=" + this.successQps + ", exception=" + this.exception + ", rt=" + this.rt + ", name='" + this.name + '\'' + '}';
    }

    public String toThinString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.timestamp).append("|");
        String legalName = this.name.replaceAll("\\|", "_");
        sb.append(legalName).append("|");
        sb.append(this.passedQps).append("|");
        sb.append(this.blockedQps).append("|");
        sb.append(this.successQps).append("|");
        sb.append(this.exception).append("|");
        sb.append(this.rt);
        return sb.toString();
    }

    public static MetricNode fromThinString(String line) {
        MetricNode node = new MetricNode();
        String[] strs = line.split("\\|");
        node.setTimestamp(Long.parseLong(strs[0]));
        node.setName(strs[1]);
        node.setPassedQps(Long.parseLong(strs[2]));
        node.setBlockedQps(Long.parseLong(strs[3]));
        node.setSuccessQps(Long.parseLong(strs[4]));
        node.setException(Long.parseLong(strs[5]));
        node.setRt(Long.parseLong(strs[6]));
        return node;
    }

    public String toFatString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder sb = new StringBuilder(32);
        sb.delete(0, sb.length());
        sb.append(this.getTimestamp()).append("|");
        sb.append(df.format(new Date(this.getTimestamp()))).append("|");
        String legalName = this.getName().replaceAll("\\|", "_");
        sb.append(legalName).append("|");
        sb.append(this.getPassedQps()).append("|");
        sb.append(this.getBlockedQps()).append("|");
        sb.append(this.getSuccessQps()).append("|");
        sb.append(this.getException()).append("|");
        sb.append(this.getRt());
        sb.append('\n');
        return sb.toString();
    }

    public static MetricNode fromFatString(String line) {
        String[] strs = line.split("\\|");
        Long time = Long.parseLong(strs[0]);
        MetricNode node = new MetricNode();
        node.setTimestamp(time);
        node.setName(strs[2]);
        node.setPassedQps(Long.parseLong(strs[3]));
        node.setBlockedQps(Long.parseLong(strs[4]));
        node.setSuccessQps(Long.parseLong(strs[5]));
        node.setException(Long.parseLong(strs[6]));
        node.setRt(Long.parseLong(strs[7]));
        return node;
    }
}

