/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.log;

import com.alibaba.csp.sentinel.log.CspFormatter;
import com.alibaba.csp.sentinel.log.DateFileLogHandler;
import com.alibaba.csp.sentinel.log.LoggerUtils;
import com.alibaba.csp.sentinel.util.PidUtil;
import java.io.File;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogBase {
    public static final String LOG_CHARSET = "utf-8";
    private static final String DIR_NAME = "logs" + File.separator + "csp";
    private static final String USER_HOME = "user.home";
    private static String logBaseDir;

    public static String getLogBaseDir() {
        return logBaseDir;
    }

    protected static void setLogBaseDir(String baseDir) {
        String path;
        File dir;
        if (!baseDir.endsWith(File.separator)) {
            baseDir = baseDir + File.separator;
        }
        if (!(dir = new File(path = baseDir + DIR_NAME + File.separator)).exists()) {
            dir.mkdirs();
        }
        logBaseDir = path;
    }

    protected static Handler makeLogger(String logName, Logger heliumRecordLog) {
        CspFormatter formatter = new CspFormatter();
        String fileName = LogBase.getLogBaseDir() + logName + ".pid" + PidUtil.getPid();
        DateFileLogHandler handler = null;
        try {
            handler = new DateFileLogHandler(fileName + ".%d", 0xC800000, 1, true);
            ((Handler)handler).setFormatter(formatter);
            handler.setEncoding(LOG_CHARSET);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (handler != null) {
            LoggerUtils.disableOtherHandlers(heliumRecordLog, handler);
        }
        heliumRecordLog.setLevel(Level.ALL);
        return handler;
    }

    static {
        String userHome = System.getProperty(USER_HOME);
        LogBase.setLogBaseDir(userHome);
    }
}

