/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node.metric;

import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.node.metric.MetricNode;
import com.alibaba.csp.sentinel.node.metric.MetricWriter;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class MetricSearcher {
    private static final Charset defaultCharset = Charset.forName(SentinelConfig.charset());
    private String baseDir;
    private String baseFileName;
    private Charset charset;
    private Position lastPosition = new Position();
    private static final int maxLinesReturn = 100000;

    public MetricSearcher(String baseDir, String baseFileName) {
        this(baseDir, baseFileName, defaultCharset);
    }

    public MetricSearcher(String baseDir, String baseFileName, Charset charset) {
        if (baseDir == null) {
            throw new IllegalArgumentException("baseDir can't be null");
        }
        if (baseFileName == null) {
            throw new IllegalArgumentException("baseFileName can't be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset can't be null");
        }
        this.baseDir = baseDir;
        if (!baseDir.endsWith(File.separator)) {
            this.baseDir = this.baseDir + File.separator;
        }
        this.baseFileName = baseFileName;
        this.charset = charset;
    }

    public synchronized List<MetricNode> find(long beginTimeMs, int recommendLines) throws Exception {
        List<String> fileNames = MetricWriter.listMetricFiles(this.baseDir, this.baseFileName);
        int i = 0;
        long offsetInIndex = 0L;
        if (this.validPosition(beginTimeMs)) {
            i = fileNames.indexOf(this.lastPosition.metricFileName);
            if (i == -1) {
                i = 0;
            } else {
                offsetInIndex = this.lastPosition.offsetInIndex;
            }
        }
        while (i < fileNames.size()) {
            String fileName = fileNames.get(i);
            long offset = this.findOffset(beginTimeMs, fileName, MetricWriter.formIndexFileName(fileName), offsetInIndex);
            offsetInIndex = 0L;
            if (offset != -1L) {
                return this.readMetrics(fileNames, i, offset, recommendLines);
            }
            ++i;
        }
        return null;
    }

    public synchronized List<MetricNode> findByTimeAndResource(long beginTimeMs, long endTimeMs, String identity) throws Exception {
        List<String> fileNames = MetricWriter.listMetricFiles(this.baseDir, this.baseFileName);
        int i = 0;
        long offsetInIndex = 0L;
        if (this.validPosition(beginTimeMs)) {
            i = fileNames.indexOf(this.lastPosition.metricFileName);
            if (i == -1) {
                i = 0;
            } else {
                offsetInIndex = this.lastPosition.offsetInIndex;
            }
        }
        while (i < fileNames.size()) {
            String fileName = fileNames.get(i);
            long offset = this.findOffset(beginTimeMs, fileName, fileName + ".idx", offsetInIndex);
            offsetInIndex = 0L;
            if (offset != -1L) {
                return this.readMetricsByEndTime(fileNames, i, offset, endTimeMs, identity);
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validPosition(long beginTimeMs) {
        if (beginTimeMs / 1000L < this.lastPosition.second) {
            return false;
        }
        if (this.lastPosition.indexFileName == null) {
            return false;
        }
        if (!new File(this.lastPosition.indexFileName).exists()) {
            return false;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.lastPosition.indexFileName);
            in.getChannel().position(this.lastPosition.offsetInIndex);
            DataInputStream indexIn = new DataInputStream(in);
            boolean bl = indexIn.readLong() == this.lastPosition.second;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readMetricsInOneFileByEndTime(List<MetricNode> list, String fileName, long offset, long endTimeMs, String identity) throws Exception {
        FileInputStream in = null;
        long endSecond = endTimeMs / 1000L;
        try {
            String line;
            in = new FileInputStream(fileName);
            in.getChannel().position(offset);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, this.charset));
            while ((line = reader.readLine()) != null) {
                MetricNode node = MetricNode.fromFatString(line);
                long currentSecond = node.getTimestamp() / 1000L;
                if (currentSecond <= endSecond) {
                    if (identity == null) {
                        list.add(node);
                    } else if (node.getResource().equals(identity)) {
                        list.add(node);
                    }
                } else {
                    boolean bl = false;
                    return bl;
                }
                if (list.size() < 100000) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMetricsInOneFile(List<MetricNode> list, String fileName, long offset, int recommendLines) throws Exception {
        long lastSecond = -1L;
        if (list.size() > 0) {
            lastSecond = list.get(list.size() - 1).getTimestamp() / 1000L;
        }
        FileInputStream in = null;
        try {
            String line;
            in = new FileInputStream(fileName);
            in.getChannel().position(offset);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, this.charset));
            while ((line = reader.readLine()) != null) {
                MetricNode node = MetricNode.fromFatString(line);
                long currentSecond = node.getTimestamp() / 1000L;
                if (list.size() < recommendLines) {
                    list.add(node);
                } else {
                    if (currentSecond != lastSecond) break;
                    list.add(node);
                }
                lastSecond = currentSecond;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private List<MetricNode> readMetrics(List<String> fileNames, int pos, long offset, int recommendLines) throws Exception {
        ArrayList<MetricNode> list = new ArrayList<MetricNode>(recommendLines);
        this.readMetricsInOneFile(list, fileNames.get(pos++), offset, recommendLines);
        while (list.size() < recommendLines && pos < fileNames.size()) {
            this.readMetricsInOneFile(list, fileNames.get(pos++), 0L, recommendLines);
        }
        return list;
    }

    private List<MetricNode> readMetricsByEndTime(List<String> fileNames, int pos, long offset, long endTimeMs, String identity) throws Exception {
        ArrayList<MetricNode> list = new ArrayList<MetricNode>(1024);
        if (this.readMetricsInOneFileByEndTime(list, fileNames.get(pos++), offset, endTimeMs, identity)) {
            while (pos < fileNames.size() && this.readMetricsInOneFileByEndTime(list, fileNames.get(pos++), 0L, endTimeMs, identity)) {
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findOffset(long beginTime, String metricFileName, String idxFileName, long offsetInIndex) throws Exception {
        this.lastPosition.metricFileName = null;
        this.lastPosition.indexFileName = null;
        if (!new File(idxFileName).exists()) {
            return -1L;
        }
        long beginSecond = beginTime / 1000L;
        FileInputStream in = new FileInputStream(idxFileName);
        in.getChannel().position(offsetInIndex);
        DataInputStream indexIn = new DataInputStream(in);
        try {
            long offset;
            long second;
            this.lastPosition.offsetInIndex = in.getChannel().position();
            while ((second = indexIn.readLong()) < beginSecond) {
                offset = indexIn.readLong();
                this.lastPosition.offsetInIndex = in.getChannel().position();
            }
            offset = indexIn.readLong();
            this.lastPosition.metricFileName = metricFileName;
            this.lastPosition.indexFileName = idxFileName;
            this.lastPosition.second = second;
            long l = offset;
            return l;
        }
        catch (EOFException ignore) {
            long l = -1L;
            return l;
        }
        finally {
            indexIn.close();
        }
    }

    private static final class Position {
        String metricFileName;
        String indexFileName;
        long offsetInIndex;
        long second;

        private Position() {
        }
    }
}

