/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.authority;

import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.slots.block.AbstractRule;
import com.alibaba.csp.sentinel.util.StringUtil;

public class AuthorityRule
extends AbstractRule {
    private int strategy;

    public int getStrategy() {
        return this.strategy;
    }

    public void setStrategy(int strategy) {
        this.strategy = strategy;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthorityRule)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthorityRule rule = (AuthorityRule)o;
        return this.strategy == rule.strategy;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.strategy;
        return result;
    }

    @Override
    public boolean passCheck(Context context, DefaultNode node, int count, Object ... args) {
        boolean contain;
        String requester = context.getOrigin();
        if (StringUtil.isEmpty(requester) || this.getLimitApp() == null) {
            return true;
        }
        int pos = this.getLimitApp().indexOf(requester);
        boolean bl = contain = pos > -1;
        if (contain) {
            String[] appArray;
            boolean exactlyMatch = false;
            for (String app : appArray = this.getLimitApp().split(",")) {
                if (!requester.equals(app)) continue;
                exactlyMatch = true;
                break;
            }
            contain = exactlyMatch;
        }
        if (this.strategy == 1 && contain) {
            return false;
        }
        return this.strategy != 0 || contain;
    }

    public String toString() {
        return "AuthorityRule{resource=" + this.getResource() + ", limitApp=" + this.getLimitApp() + ", strategy=" + this.strategy + "} " + super.toString();
    }
}

