/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.degrade;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.slots.block.AbstractRule;
import com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class DegradeRule
extends AbstractRule {
    private static final int RT_MAX_EXCEED_N = 5;
    private static ScheduledExecutorService pool = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), new NamedThreadFactory("sentinel-degrade-reset-task", true));
    private double count;
    private int timeWindow;
    private int grade = 0;
    private volatile boolean cut = false;
    private AtomicLong passCount = new AtomicLong(0L);
    private final Object lock = new Object();

    public int getGrade() {
        return this.grade;
    }

    public void setGrade(int grade) {
        this.grade = grade;
    }

    public double getCount() {
        return this.count;
    }

    public void setCount(double count) {
        this.count = count;
    }

    public boolean isCut() {
        return this.cut;
    }

    private void setCut(boolean cut) {
        this.cut = cut;
    }

    public AtomicLong getPassCount() {
        return this.passCount;
    }

    public int getTimeWindow() {
        return this.timeWindow;
    }

    public void setTimeWindow(int timeWindow) {
        this.timeWindow = timeWindow;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DegradeRule)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DegradeRule that = (DegradeRule)o;
        if (this.count != that.count) {
            return false;
        }
        if (this.timeWindow != that.timeWindow) {
            return false;
        }
        return this.grade == that.grade;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + new Double(this.count).hashCode();
        result = 31 * result + this.timeWindow;
        result = 31 * result + this.grade;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean passCheck(Context context, DefaultNode node, int acquireCount, Object ... args) {
        if (this.cut) {
            return false;
        }
        ClusterNode clusterNode = ClusterBuilderSlot.getClusterNode(this.getResource());
        if (clusterNode == null) {
            return true;
        }
        if (this.grade == 0) {
            double rt = clusterNode.avgRt();
            if (rt < this.count) {
                this.passCount.set(0L);
                return true;
            }
            if (this.passCount.incrementAndGet() < 5L) {
                return true;
            }
        } else {
            double exception = clusterNode.exceptionQps();
            double success = clusterNode.successQps();
            long total = clusterNode.totalQps();
            if (total < 5L) {
                return true;
            }
            if (success == 0.0) {
                return exception < 5.0;
            }
            if (exception / (success + exception) < this.count) {
                return true;
            }
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.cut) {
                this.cut = true;
                ResetTask resetTask = new ResetTask(this);
                pool.schedule(resetTask, (long)this.timeWindow, TimeUnit.SECONDS);
            }
            return false;
        }
    }

    public String toString() {
        return "DegradeRule{resource=" + this.getResource() + ", grade=" + this.grade + ", count=" + this.count + ", limitApp=" + this.getLimitApp() + ", timeWindow=" + this.timeWindow + "}";
    }

    private static final class ResetTask
    implements Runnable {
        private DegradeRule rule;

        ResetTask(DegradeRule rule) {
            this.rule = rule;
        }

        @Override
        public void run() {
            this.rule.getPassCount().set(0L);
            this.rule.setCut(false);
        }
    }
}

