/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow;

import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.node.Node;
import com.alibaba.csp.sentinel.slots.block.AbstractRule;
import com.alibaba.csp.sentinel.slots.block.flow.Controller;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;
import com.alibaba.csp.sentinel.util.StringUtil;

public class FlowRule
extends AbstractRule {
    public static final String LIMIT_APP_DEFAULT = "default";
    public static final String LIMIT_APP_OTHER = "other";
    private int grade = 1;
    private double count;
    private int strategy = 0;
    private String refResource;
    private int controlBehavior = 0;
    private int warmUpPeriodSec = 10;
    private int maxQueueingTimeMs = 500;
    private Controller controller;

    public FlowRule() {
        this.setLimitApp(LIMIT_APP_DEFAULT);
    }

    public int getControlBehavior() {
        return this.controlBehavior;
    }

    public FlowRule setControlBehavior(int controlBehavior) {
        this.controlBehavior = controlBehavior;
        return this;
    }

    public int getMaxQueueingTimeMs() {
        return this.maxQueueingTimeMs;
    }

    public FlowRule setMaxQueueingTimeMs(int maxQueueingTimeMs) {
        this.maxQueueingTimeMs = maxQueueingTimeMs;
        return this;
    }

    public FlowRule setRater(Controller rater) {
        this.controller = rater;
        return this;
    }

    public int getWarmUpPeriodSec() {
        return this.warmUpPeriodSec;
    }

    public FlowRule setWarmUpPeriodSec(int warmUpPeriodSec) {
        this.warmUpPeriodSec = warmUpPeriodSec;
        return this;
    }

    public int getGrade() {
        return this.grade;
    }

    public FlowRule setGrade(int grade) {
        this.grade = grade;
        return this;
    }

    public double getCount() {
        return this.count;
    }

    public FlowRule setCount(double count) {
        this.count = count;
        return this;
    }

    public int getStrategy() {
        return this.strategy;
    }

    public FlowRule setStrategy(int strategy) {
        this.strategy = strategy;
        return this;
    }

    public String getRefResource() {
        return this.refResource;
    }

    public FlowRule setRefResource(String refResource) {
        this.refResource = refResource;
        return this;
    }

    @Override
    public boolean passCheck(Context context, DefaultNode node, int acquireCount, Object ... args) {
        String limitApp = this.getLimitApp();
        if (limitApp == null) {
            return true;
        }
        String origin = context.getOrigin();
        Node selectedNode = this.selectNodeByRequesterAndStrategy(origin, context, node);
        if (selectedNode == null) {
            return true;
        }
        return this.controller.canPass(selectedNode, acquireCount);
    }

    private Node selectNodeByRequesterAndStrategy(String origin, Context context, DefaultNode node) {
        String limitApp = this.getLimitApp();
        if (limitApp.equals(origin)) {
            if (this.strategy == 0) {
                return context.getOriginNode();
            }
            String refResource = this.getRefResource();
            if (StringUtil.isEmpty(refResource)) {
                return null;
            }
            if (this.strategy == 1) {
                return ClusterBuilderSlot.getClusterNode(refResource);
            }
            if (this.strategy == 2) {
                if (!refResource.equals(context.getName())) {
                    return null;
                }
                return node;
            }
        } else if (LIMIT_APP_DEFAULT.equals(limitApp)) {
            if (this.strategy == 0) {
                return node.getClusterNode();
            }
            String refResource = this.getRefResource();
            if (StringUtil.isEmpty(refResource)) {
                return null;
            }
            if (this.strategy == 1) {
                return ClusterBuilderSlot.getClusterNode(refResource);
            }
            if (this.strategy == 2) {
                if (!refResource.equals(context.getName())) {
                    return null;
                }
                return node;
            }
        } else if (LIMIT_APP_OTHER.equals(limitApp) && FlowRuleManager.isOtherOrigin(origin, this.getResource())) {
            if (this.strategy == 0) {
                return context.getOriginNode();
            }
            String refResource = this.getRefResource();
            if (StringUtil.isEmpty(refResource)) {
                return null;
            }
            if (this.strategy == 1) {
                return ClusterBuilderSlot.getClusterNode(refResource);
            }
            if (this.strategy == 2) {
                if (!refResource.equals(context.getName())) {
                    return null;
                }
                if (node != null) {
                    return node;
                }
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlowRule)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FlowRule flowRule = (FlowRule)o;
        if (this.grade != flowRule.grade) {
            return false;
        }
        if (Double.compare(flowRule.count, this.count) != 0) {
            return false;
        }
        if (this.strategy != flowRule.strategy) {
            return false;
        }
        if (this.refResource != null ? !this.refResource.equals(flowRule.refResource) : flowRule.refResource != null) {
            return false;
        }
        if (this.controlBehavior != flowRule.controlBehavior) {
            return false;
        }
        return this.warmUpPeriodSec == flowRule.warmUpPeriodSec;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.grade;
        long temp = Double.doubleToLongBits(this.count);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.strategy;
        result = 31 * result + (this.refResource != null ? this.refResource.hashCode() : 0);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.warmUpPeriodSec;
        result = 31 * result + this.controlBehavior;
        return result;
    }

    public String toString() {
        return "FlowRule{resource=" + this.getResource() + ", limitApp=" + this.getLimitApp() + ", grade=" + this.grade + ", count=" + this.count + ", strategy=" + this.strategy + ", refResource=" + this.refResource + ", controlBehavior=" + this.controlBehavior + ", warmUpPeriodSec=" + this.warmUpPeriodSec + ", maxQueueingTimeMs=" + this.maxQueueingTimeMs + ", controller=" + this.controller + "}";
    }
}

