/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.statistic.base;

import com.alibaba.csp.sentinel.slots.statistic.base.WindowWrap;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;

public abstract class LeapArray<T> {
    protected int windowLength;
    protected int sampleCount;
    protected int intervalInMs;
    protected AtomicReferenceArray<WindowWrap<T>> array;

    public LeapArray(int windowLength, int intervalInSec) {
        this.windowLength = windowLength;
        this.sampleCount = intervalInSec * 1000 / windowLength;
        this.intervalInMs = intervalInSec * 1000;
        this.array = new AtomicReferenceArray(this.sampleCount);
    }

    public WindowWrap<T> currentWindow() {
        return this.currentWindow(TimeUtil.currentTimeMillis());
    }

    public abstract WindowWrap<T> currentWindow(long var1);

    public WindowWrap<T> getPreviousWindow(long time) {
        long timeId = (time - (long)this.windowLength) / (long)this.windowLength;
        int idx = (int)(timeId % (long)this.array.length());
        time -= (long)this.windowLength;
        WindowWrap<T> wrap = this.array.get(idx);
        if (wrap == null || this.isWindowDeprecated(wrap)) {
            return null;
        }
        if (wrap.windowStart() + (long)this.windowLength < time) {
            return null;
        }
        return wrap;
    }

    public WindowWrap<T> getPreviousWindow() {
        return this.getPreviousWindow(System.currentTimeMillis());
    }

    public T getWindowValue(long time) {
        long timeId = time / (long)this.windowLength;
        int idx = (int)(timeId % (long)this.array.length());
        WindowWrap<T> old = this.array.get(idx);
        if (old == null || this.isWindowDeprecated(old)) {
            return null;
        }
        return old.value();
    }

    AtomicReferenceArray<WindowWrap<T>> array() {
        return this.array;
    }

    private boolean isWindowDeprecated(WindowWrap<T> windowWrap) {
        return TimeUtil.currentTimeMillis() - windowWrap.windowStart() >= (long)this.intervalInMs;
    }

    public List<WindowWrap<T>> list() {
        ArrayList<WindowWrap<T>> result = new ArrayList<WindowWrap<T>>();
        for (int i = 0; i < this.array.length(); ++i) {
            WindowWrap<T> windowWrap = this.array.get(i);
            if (windowWrap == null || this.isWindowDeprecated(windowWrap)) continue;
            result.add(windowWrap);
        }
        return result;
    }

    public List<T> values() {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < this.array.length(); ++i) {
            WindowWrap<T> windowWrap = this.array.get(i);
            if (windowWrap == null || this.isWindowDeprecated(windowWrap)) continue;
            result.add(windowWrap.value());
        }
        return result;
    }
}

