/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.statistic.base;

import com.alibaba.csp.sentinel.slots.statistic.base.LongAdder;

public class Window {
    private final LongAdder pass = new LongAdder();
    private final LongAdder block = new LongAdder();
    private final LongAdder exception = new LongAdder();
    private final LongAdder rt = new LongAdder();
    private final LongAdder success = new LongAdder();
    private final LongAdder minRt = new LongAdder();

    public Window() {
        this.initMinRt();
    }

    private void initMinRt() {
        this.minRt.add(4900L);
    }

    public Window reset() {
        this.pass.reset();
        this.block.reset();
        this.exception.reset();
        this.rt.reset();
        this.success.reset();
        this.minRt.reset();
        this.initMinRt();
        return this;
    }

    public long pass() {
        return this.pass.sum();
    }

    public long block() {
        return this.block.sum();
    }

    public long exception() {
        return this.exception.sum();
    }

    public long rt() {
        return this.rt.sum();
    }

    public long minRt() {
        return this.minRt.longValue();
    }

    public long success() {
        return this.success.sum();
    }

    public void addPass() {
        this.pass.add(1L);
    }

    public void addException() {
        this.exception.add(1L);
    }

    public void addBlock() {
        this.block.add(1L);
    }

    public void addSuccess() {
        this.success.add(1L);
    }

    public void addRT(long rt) {
        this.rt.add(rt);
        if (this.minRt.longValue() > rt) {
            this.minRt.internalReset(rt);
        }
    }
}

