/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.statistic.metric;

import com.alibaba.csp.sentinel.slots.statistic.base.LeapArray;
import com.alibaba.csp.sentinel.slots.statistic.base.Window;
import com.alibaba.csp.sentinel.slots.statistic.base.WindowWrap;
import java.util.concurrent.locks.ReentrantLock;

public class WindowLeapArray
extends LeapArray<Window> {
    private ReentrantLock addLock = new ReentrantLock();

    public WindowLeapArray(int windowLengthInMs, int intervalInSec) {
        super(windowLengthInMs, intervalInSec);
    }

    private WindowWrap<Window> resetWindowTo(WindowWrap<Window> w, long startTime) {
        w.resetTo(startTime);
        w.value().reset();
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WindowWrap<Window> currentWindow(long time) {
        long timeId = time / (long)this.windowLength;
        int idx = (int)(timeId % (long)this.array.length());
        time -= time % (long)this.windowLength;
        while (true) {
            WindowWrap old;
            if ((old = (WindowWrap)this.array.get(idx)) == null) {
                WindowWrap<Window> window = new WindowWrap<Window>(this.windowLength, time, new Window());
                if (this.array.compareAndSet(idx, null, window)) {
                    return window;
                }
                Thread.yield();
                continue;
            }
            if (time == old.windowStart()) {
                return old;
            }
            if (time > old.windowStart()) {
                if (this.addLock.tryLock()) {
                    try {
                        WindowWrap<Window> windowWrap = this.resetWindowTo(old, time);
                        return windowWrap;
                    }
                    finally {
                        this.addLock.unlock();
                    }
                }
                Thread.yield();
                continue;
            }
            if (time < old.windowStart()) break;
        }
        return new WindowWrap<Window>(this.windowLength, time, new Window());
    }
}

