/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.node.metric.MetricTimerListener;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.flow.ColdFactorProperty;
import com.alibaba.csp.sentinel.slots.block.flow.Controller;
import com.alibaba.csp.sentinel.slots.block.flow.FlowException;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.controller.DefaultController;
import com.alibaba.csp.sentinel.slots.block.flow.controller.PaceController;
import com.alibaba.csp.sentinel.slots.block.flow.controller.WarmUpController;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class FlowRuleManager {
    private static final Map<String, List<FlowRule>> flowRules = new ConcurrentHashMap<String, List<FlowRule>>();
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new NamedThreadFactory("sentinel-metrics-record-task", true));
    private static final FlowPropertyListener listener = new FlowPropertyListener();
    private static SentinelProperty<List<FlowRule>> currentProperty = new DynamicSentinelProperty<List<FlowRule>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<List<FlowRule>> property) {
        FlowPropertyListener flowPropertyListener = listener;
        synchronized (flowPropertyListener) {
            RecordLog.info("[FlowRuleManager] Registering new property to flow rule manager", new Object[0]);
            currentProperty.removeListener(listener);
            property.addListener(listener);
            currentProperty = property;
        }
    }

    public static List<FlowRule> getRules() {
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        for (Map.Entry<String, List<FlowRule>> entry : flowRules.entrySet()) {
            rules.addAll((Collection<FlowRule>)entry.getValue());
        }
        return rules;
    }

    public static void loadRules(List<FlowRule> rules) {
        currentProperty.updateValue(rules);
    }

    private static Map<String, List<FlowRule>> loadFlowConf(List<FlowRule> list) {
        ConcurrentHashMap<String, List<FlowRule>> newRuleMap = new ConcurrentHashMap<String, List<FlowRule>>();
        if (list == null || list.isEmpty()) {
            return newRuleMap;
        }
        for (FlowRule rule : list) {
            if (!FlowRuleManager.isValidRule(rule)) {
                RecordLog.warn("[FlowRuleManager] Ignoring invalid flow rule when loading new flow rules: " + rule, new Object[0]);
                continue;
            }
            if (StringUtil.isBlank(rule.getLimitApp())) {
                rule.setLimitApp("default");
            }
            Controller rater = new DefaultController(rule.getCount(), rule.getGrade());
            if (rule.getGrade() == 1 && rule.getControlBehavior() == 1 && rule.getWarmUpPeriodSec() > 0) {
                rater = new WarmUpController(rule.getCount(), rule.getWarmUpPeriodSec(), ColdFactorProperty.coldFactor);
            } else if (rule.getGrade() == 1 && rule.getControlBehavior() == 2 && rule.getMaxQueueingTimeMs() > 0) {
                rater = new PaceController(rule.getMaxQueueingTimeMs(), rule.getCount());
            }
            rule.setRater(rater);
            String identity = rule.getResource();
            ArrayList<FlowRule> ruleM = (ArrayList<FlowRule>)newRuleMap.get(identity);
            if (ruleM == null) {
                ruleM = new ArrayList<FlowRule>();
                newRuleMap.put(identity, ruleM);
            }
            ruleM.add(rule);
        }
        return newRuleMap;
    }

    public static void checkFlow(ResourceWrapper resource, Context context, DefaultNode node, int count) throws BlockException {
        List<FlowRule> rules = flowRules.get(resource.getName());
        if (rules != null) {
            for (FlowRule rule : rules) {
                if (rule.passCheck(context, node, count, new Object[0])) continue;
                throw new FlowException(rule.getLimitApp());
            }
        }
    }

    public static boolean hasConfig(String resource) {
        return flowRules.containsKey(resource);
    }

    public static boolean isOtherOrigin(String origin, String resourceName) {
        if (StringUtil.isEmpty(origin)) {
            return false;
        }
        List<FlowRule> rules = flowRules.get(resourceName);
        if (rules != null) {
            for (FlowRule rule : rules) {
                if (!origin.equals(rule.getLimitApp())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isValidRule(FlowRule rule) {
        boolean baseValid;
        boolean bl = baseValid = rule != null && !StringUtil.isBlank(rule.getResource()) && rule.getCount() >= 0.0 && rule.getGrade() >= 0 && rule.getStrategy() >= 0 && rule.getControlBehavior() >= 0;
        if (!baseValid) {
            return false;
        }
        return FlowRuleManager.checkStrategyField(rule) && FlowRuleManager.checkControlBehaviorField(rule);
    }

    private static boolean checkStrategyField(FlowRule rule) {
        if (rule.getStrategy() == 1 || rule.getStrategy() == 2) {
            return StringUtil.isNotBlank(rule.getRefResource());
        }
        return true;
    }

    private static boolean checkControlBehaviorField(FlowRule rule) {
        switch (rule.getControlBehavior()) {
            case 1: {
                return rule.getWarmUpPeriodSec() > 0;
            }
            case 2: {
                return rule.getMaxQueueingTimeMs() > 0;
            }
        }
        return true;
    }

    static {
        currentProperty.addListener(listener);
        scheduler.scheduleAtFixedRate(new MetricTimerListener(), 0L, 1L, TimeUnit.SECONDS);
    }

    private static final class FlowPropertyListener
    implements PropertyListener<List<FlowRule>> {
        private FlowPropertyListener() {
        }

        @Override
        public void configUpdate(List<FlowRule> value) {
            Map rules = FlowRuleManager.loadFlowConf(value);
            if (rules != null) {
                flowRules.clear();
                flowRules.putAll(rules);
            }
            RecordLog.info("[FlowRuleManager] Flow rules received: " + flowRules, new Object[0]);
        }

        @Override
        public void configLoad(List<FlowRule> conf) {
            Map rules = FlowRuleManager.loadFlowConf(conf);
            if (rules != null) {
                flowRules.clear();
                flowRules.putAll(rules);
            }
            RecordLog.info("[FlowRuleManager] Flow rules loaded: " + flowRules, new Object[0]);
        }
    }
}

