/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.statistic.base;

import com.alibaba.csp.sentinel.slots.statistic.base.WindowWrap;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;

public abstract class LeapArray<T> {
    protected int windowLengthInMs;
    protected int sampleCount;
    protected int intervalInMs;
    protected final AtomicReferenceArray<WindowWrap<T>> array;
    private final ReentrantLock updateLock = new ReentrantLock();

    public LeapArray(int windowLengthInMs, int intervalInSec) {
        this.windowLengthInMs = windowLengthInMs;
        this.intervalInMs = intervalInSec * 1000;
        this.sampleCount = this.intervalInMs / windowLengthInMs;
        this.array = new AtomicReferenceArray(this.sampleCount);
    }

    public WindowWrap<T> currentWindow() {
        return this.currentWindow(TimeUtil.currentTimeMillis());
    }

    public abstract T newEmptyBucket();

    protected abstract WindowWrap<T> resetWindowTo(WindowWrap<T> var1, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowWrap<T> currentWindow(long time) {
        long timeId = time / (long)this.windowLengthInMs;
        int idx = (int)(timeId % (long)this.array.length());
        time -= time % (long)this.windowLengthInMs;
        while (true) {
            WindowWrap<T> old;
            if ((old = this.array.get(idx)) == null) {
                WindowWrap<T> window = new WindowWrap<T>(this.windowLengthInMs, time, this.newEmptyBucket());
                if (this.array.compareAndSet(idx, null, window)) {
                    return window;
                }
                Thread.yield();
                continue;
            }
            if (time == old.windowStart()) {
                return old;
            }
            if (time > old.windowStart()) {
                if (this.updateLock.tryLock()) {
                    try {
                        WindowWrap<T> windowWrap = this.resetWindowTo(old, time);
                        return windowWrap;
                    }
                    finally {
                        this.updateLock.unlock();
                    }
                }
                Thread.yield();
                continue;
            }
            if (time < old.windowStart()) break;
        }
        return new WindowWrap<T>(this.windowLengthInMs, time, this.newEmptyBucket());
    }

    public WindowWrap<T> getPreviousWindow(long time) {
        long timeId = (time - (long)this.windowLengthInMs) / (long)this.windowLengthInMs;
        int idx = (int)(timeId % (long)this.array.length());
        time -= (long)this.windowLengthInMs;
        WindowWrap<T> wrap = this.array.get(idx);
        if (wrap == null || this.isWindowDeprecated(wrap)) {
            return null;
        }
        if (wrap.windowStart() + (long)this.windowLengthInMs < time) {
            return null;
        }
        return wrap;
    }

    public WindowWrap<T> getPreviousWindow() {
        return this.getPreviousWindow(System.currentTimeMillis());
    }

    public T getWindowValue(long time) {
        long timeId = time / (long)this.windowLengthInMs;
        int idx = (int)(timeId % (long)this.array.length());
        WindowWrap<T> old = this.array.get(idx);
        if (old == null || this.isWindowDeprecated(old)) {
            return null;
        }
        return old.value();
    }

    private boolean isWindowDeprecated(WindowWrap<T> windowWrap) {
        return TimeUtil.currentTimeMillis() - windowWrap.windowStart() >= (long)this.intervalInMs;
    }

    public List<WindowWrap<T>> list() {
        ArrayList<WindowWrap<T>> result = new ArrayList<WindowWrap<T>>();
        for (int i = 0; i < this.array.length(); ++i) {
            WindowWrap<T> windowWrap = this.array.get(i);
            if (windowWrap == null || this.isWindowDeprecated(windowWrap)) continue;
            result.add(windowWrap);
        }
        return result;
    }

    public List<T> values() {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < this.array.length(); ++i) {
            WindowWrap<T> windowWrap = this.array.get(i);
            if (windowWrap == null || this.isWindowDeprecated(windowWrap)) continue;
            result.add(windowWrap.value());
        }
        return result;
    }
}

