/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.system;

import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;

public class SystemStatusListener
implements Runnable {
    volatile double currentLoad = -1.0;
    volatile String reason = "";
    static final int processor = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();

    public double getSystemAverageLoad() {
        return this.currentLoad;
    }

    @Override
    public void run() {
        try {
            if (!SystemRuleManager.getCheckSystemStatus().booleanValue()) {
                return;
            }
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            this.currentLoad = operatingSystemMXBean.getSystemLoadAverage();
            StringBuilder sb = new StringBuilder();
            if (this.currentLoad > SystemRuleManager.getHighestSystemLoad()) {
                sb.append("load:").append(this.currentLoad).append(";");
                sb.append("qps:").append(Constants.ENTRY_NODE.passQps()).append(";");
                sb.append("rt:").append(Constants.ENTRY_NODE.avgRt()).append(";");
                sb.append("thread:").append(Constants.ENTRY_NODE.curThreadNum()).append(";");
                sb.append("success:").append(Constants.ENTRY_NODE.successQps()).append(";");
                sb.append("minRt:").append(Constants.ENTRY_NODE.minRt()).append(";");
                sb.append("maxSuccess:").append(Constants.ENTRY_NODE.maxSuccessQps()).append(";");
                RecordLog.info(sb.toString(), new Object[0]);
            }
        }
        catch (Throwable e) {
            RecordLog.info("could not get system error ", e);
        }
    }
}

