/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.util;

import com.alibaba.csp.sentinel.log.RecordLog;
import java.io.File;

public final class AppNameUtil {
    public static final String APP_NAME = "project.name";
    public static final String SUN_JAVA_COMMAND = "sun.java.command";
    private static final String JAR_SUFFIX_LOWER = ".jar";
    private static final String JAR_SUFFIX_UPPER = ".JAR";
    private static String appName;

    private AppNameUtil() {
    }

    public static void resolveAppName() {
        String separator;
        String app = System.getProperty(APP_NAME);
        if (!AppNameUtil.isEmpty(app)) {
            appName = app;
            return;
        }
        String command = System.getProperty(SUN_JAVA_COMMAND);
        if (AppNameUtil.isEmpty(command)) {
            return;
        }
        if ((command = command.split("\\s")[0]).contains(separator = File.separator)) {
            String[] strs = "\\".equals(separator) ? command.split("\\\\") : command.split(separator);
            command = strs[strs.length - 1];
        }
        if (command.endsWith(JAR_SUFFIX_LOWER) || command.endsWith(JAR_SUFFIX_UPPER)) {
            command = command.substring(0, command.length() - 4);
        }
        appName = command;
    }

    public static String getAppName() {
        return appName;
    }

    private static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    static {
        AppNameUtil.resolveAppName();
        RecordLog.info("App name resolved: " + appName, new Object[0]);
    }
}

