/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster;

import com.alibaba.csp.sentinel.cluster.client.ClusterTokenClient;
import com.alibaba.csp.sentinel.cluster.client.TokenClientProvider;
import com.alibaba.csp.sentinel.cluster.server.EmbeddedClusterTokenServer;
import com.alibaba.csp.sentinel.cluster.server.EmbeddedClusterTokenServerProvider;
import com.alibaba.csp.sentinel.init.InitExecutor;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.util.TimeUtil;

public final class ClusterStateManager {
    public static final int CLUSTER_CLIENT = 0;
    public static final int CLUSTER_SERVER = 1;
    public static final int CLUSTER_NOT_STARTED = -1;
    private static volatile int mode = -1;
    private static volatile long lastModified = -1L;
    private static volatile SentinelProperty<Integer> stateProperty = new DynamicSentinelProperty<Integer>();
    private static final PropertyListener<Integer> PROPERTY_LISTENER = new ClusterStatePropertyListener();
    private static final int MIN_INTERVAL = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProperty(SentinelProperty<Integer> property) {
        PropertyListener<Integer> propertyListener = PROPERTY_LISTENER;
        synchronized (propertyListener) {
            RecordLog.info("[ClusterStateManager] Registering new property to cluster state manager", new Object[0]);
            stateProperty.removeListener(PROPERTY_LISTENER);
            property.addListener(PROPERTY_LISTENER);
            stateProperty = property;
        }
    }

    public static int getMode() {
        return mode;
    }

    public static boolean isClient() {
        return mode == 0;
    }

    public static boolean isServer() {
        return mode == 1;
    }

    public static boolean setToClient() {
        if (mode == 0) {
            return true;
        }
        mode = 0;
        ClusterStateManager.sleepIfNeeded();
        lastModified = TimeUtil.currentTimeMillis();
        return ClusterStateManager.startClient();
    }

    private static boolean startClient() {
        try {
            ClusterTokenClient tokenClient;
            EmbeddedClusterTokenServer server = EmbeddedClusterTokenServerProvider.getServer();
            if (server != null) {
                server.stop();
            }
            if ((tokenClient = TokenClientProvider.getClient()) != null) {
                tokenClient.start();
                RecordLog.info("[ClusterStateManager] Changing cluster mode to client", new Object[0]);
                return true;
            }
            RecordLog.warn("[ClusterStateManager] Cannot change to client (no client SPI found)", new Object[0]);
            return false;
        }
        catch (Exception ex) {
            RecordLog.warn("[ClusterStateManager] Error when changing cluster mode to client", ex);
            return false;
        }
    }

    private static boolean stopClient() {
        try {
            ClusterTokenClient tokenClient = TokenClientProvider.getClient();
            if (tokenClient != null) {
                tokenClient.stop();
                RecordLog.info("[ClusterStateManager] Stopping the cluster token client", new Object[0]);
                return true;
            }
            RecordLog.warn("[ClusterStateManager] Cannot stop cluster token client (no server SPI found)", new Object[0]);
            return false;
        }
        catch (Exception ex) {
            RecordLog.warn("[ClusterStateManager] Error when stopping cluster token client", ex);
            return false;
        }
    }

    public static boolean setToServer() {
        if (mode == 1) {
            return true;
        }
        mode = 1;
        ClusterStateManager.sleepIfNeeded();
        lastModified = TimeUtil.currentTimeMillis();
        return ClusterStateManager.startServer();
    }

    private static boolean startServer() {
        try {
            EmbeddedClusterTokenServer server;
            ClusterTokenClient tokenClient = TokenClientProvider.getClient();
            if (tokenClient != null) {
                tokenClient.stop();
            }
            if ((server = EmbeddedClusterTokenServerProvider.getServer()) != null) {
                server.start();
                RecordLog.info("[ClusterStateManager] Changing cluster mode to server", new Object[0]);
                return true;
            }
            RecordLog.warn("[ClusterStateManager] Cannot change to server (no server SPI found)", new Object[0]);
            return false;
        }
        catch (Exception ex) {
            RecordLog.warn("[ClusterStateManager] Error when changing cluster mode to server", ex);
            return false;
        }
    }

    private static boolean stopServer() {
        try {
            EmbeddedClusterTokenServer server = EmbeddedClusterTokenServerProvider.getServer();
            if (server != null) {
                server.stop();
                RecordLog.info("[ClusterStateManager] Stopping the cluster server", new Object[0]);
                return true;
            }
            RecordLog.warn("[ClusterStateManager] Cannot stop server (no server SPI found)", new Object[0]);
            return false;
        }
        catch (Exception ex) {
            RecordLog.warn("[ClusterStateManager] Error when stopping server", ex);
            return false;
        }
    }

    private static void sleepIfNeeded() {
        if (lastModified <= 0L) {
            return;
        }
        long now = TimeUtil.currentTimeMillis();
        long durationPast = now - lastModified;
        long estimated = durationPast - 5000L;
        if (estimated < 0L) {
            try {
                Thread.sleep(-estimated);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static long getLastModified() {
        return lastModified;
    }

    private static boolean applyStateInternal(Integer state) {
        if (state == null || state < -1) {
            return false;
        }
        if (state == mode) {
            return true;
        }
        switch (state) {
            case 0: {
                return ClusterStateManager.setToClient();
            }
            case 1: {
                return ClusterStateManager.setToServer();
            }
            case -1: {
                ClusterStateManager.setStop();
                return true;
            }
        }
        RecordLog.warn("[ClusterStateManager] Ignoring unknown cluster state: " + state, new Object[0]);
        return false;
    }

    private static void setStop() {
        if (mode == -1) {
            return;
        }
        RecordLog.info("[ClusterStateManager] Changing cluster mode to not-started", new Object[0]);
        mode = -1;
        ClusterStateManager.sleepIfNeeded();
        lastModified = TimeUtil.currentTimeMillis();
        ClusterStateManager.stopClient();
        ClusterStateManager.stopServer();
    }

    public static void applyState(Integer state) {
        stateProperty.updateValue(state);
    }

    public static void markToServer() {
        mode = 1;
    }

    static {
        InitExecutor.doInit();
        stateProperty.addListener(PROPERTY_LISTENER);
    }

    private static class ClusterStatePropertyListener
    implements PropertyListener<Integer> {
        private ClusterStatePropertyListener() {
        }

        @Override
        public synchronized void configLoad(Integer value) {
            ClusterStateManager.applyStateInternal(value);
        }

        @Override
        public synchronized void configUpdate(Integer value) {
            ClusterStateManager.applyStateInternal(value);
        }
    }
}

