/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.init;

import com.alibaba.csp.sentinel.init.InitFunc;
import com.alibaba.csp.sentinel.init.InitOrder;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;

public final class InitExecutor {
    private static AtomicBoolean initialized = new AtomicBoolean(false);

    public static void doInit() {
        if (!initialized.compareAndSet(false, true)) {
            return;
        }
        try {
            ServiceLoader<InitFunc> loader = ServiceLoader.load(InitFunc.class);
            ArrayList<OrderWrapper> initList = new ArrayList<OrderWrapper>();
            for (InitFunc initFunc : loader) {
                RecordLog.info("[InitExecutor] Found init func: " + initFunc.getClass().getCanonicalName(), new Object[0]);
                InitExecutor.insertSorted(initList, initFunc);
            }
            for (OrderWrapper w : initList) {
                w.func.init();
                RecordLog.info(String.format("[InitExecutor] Initialized: %s with order %d", w.func.getClass().getCanonicalName(), w.order), new Object[0]);
            }
        }
        catch (Exception ex) {
            RecordLog.warn("[InitExecutor] Init failed", ex);
            ex.printStackTrace();
        }
        catch (Error error) {
            RecordLog.warn("[InitExecutor] Init failed with fatal error", error);
            error.printStackTrace();
            throw error;
        }
    }

    private static void insertSorted(List<OrderWrapper> list, InitFunc func) {
        int idx;
        int order = InitExecutor.resolveOrder(func);
        for (idx = 0; idx < list.size() && list.get(idx).getOrder() <= order; ++idx) {
        }
        list.add(idx, new OrderWrapper(order, func));
    }

    private static int resolveOrder(InitFunc func) {
        if (!func.getClass().isAnnotationPresent(InitOrder.class)) {
            return Integer.MAX_VALUE;
        }
        return func.getClass().getAnnotation(InitOrder.class).value();
    }

    private InitExecutor() {
    }

    private static class OrderWrapper {
        private final int order;
        private final InitFunc func;

        OrderWrapper(int order, InitFunc func) {
            this.order = order;
            this.func = func;
        }

        int getOrder() {
            return this.order;
        }

        InitFunc getFunc() {
            return this.func;
        }
    }
}

