/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.log;

import com.alibaba.csp.sentinel.log.CspFormatter;
import com.alibaba.csp.sentinel.log.DateFileLogHandler;
import com.alibaba.csp.sentinel.log.LoggerUtils;
import com.alibaba.csp.sentinel.util.PidUtil;
import java.io.File;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogBase {
    public static final String LOG_CHARSET = "utf-8";
    private static final String DIR_NAME = "logs" + File.separator + "csp";
    private static final String USER_HOME = "user.home";
    public static final String LOG_DIR = "csp.sentinel.log.dir";
    public static final String LOG_NAME_USE_PID = "csp.sentinel.log.use.pid";
    private static boolean logNameUsePid = false;
    private static String logBaseDir;

    private static void init() {
        File dir;
        String logDir = System.getProperty(LOG_DIR);
        if (logDir == null || logDir.isEmpty()) {
            logDir = System.getProperty(USER_HOME);
            logDir = LogBase.addSeparator(logDir) + DIR_NAME + File.separator;
        }
        if (!(dir = new File(logDir = LogBase.addSeparator(logDir))).exists() && !dir.mkdirs()) {
            System.err.println("ERROR: create log base dir error: " + logDir);
        }
        logBaseDir = logDir;
        System.out.println("INFO: log base dir is: " + logBaseDir);
        String usePid = System.getProperty(LOG_NAME_USE_PID, "");
        logNameUsePid = "true".equalsIgnoreCase(usePid);
        System.out.println("INFO: log name use pid is: " + logNameUsePid);
    }

    public static boolean isLogNameUsePid() {
        return logNameUsePid;
    }

    private static String addSeparator(String logDir) {
        if (!logDir.endsWith(File.separator)) {
            logDir = logDir + File.separator;
        }
        return logDir;
    }

    protected static void log(Logger logger, Handler handler, Level level, String detail, Object ... params) {
        if (detail == null) {
            return;
        }
        LoggerUtils.disableOtherHandlers(logger, handler);
        if (params.length == 0) {
            logger.log(level, detail);
        } else {
            logger.log(level, detail, params);
        }
    }

    protected static void log(Logger logger, Handler handler, Level level, String detail, Throwable throwable) {
        if (detail == null) {
            return;
        }
        LoggerUtils.disableOtherHandlers(logger, handler);
        logger.log(level, detail, throwable);
    }

    public static String getLogBaseDir() {
        return logBaseDir;
    }

    protected static Handler makeLogger(String logName, Logger heliumRecordLog) {
        CspFormatter formatter = new CspFormatter();
        String fileName = LogBase.getLogBaseDir() + logName;
        if (LogBase.isLogNameUsePid()) {
            fileName = fileName + ".pid" + PidUtil.getPid();
        }
        DateFileLogHandler handler = null;
        try {
            handler = new DateFileLogHandler(fileName + ".%d", 0xC800000, 4, true);
            ((Handler)handler).setFormatter(formatter);
            handler.setEncoding(LOG_CHARSET);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (handler != null) {
            LoggerUtils.disableOtherHandlers(heliumRecordLog, handler);
        }
        heliumRecordLog.setLevel(Level.ALL);
        return handler;
    }

    static {
        try {
            LogBase.init();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
    }
}

