/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.statistic.data;

import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.slots.statistic.MetricEvent;
import com.alibaba.csp.sentinel.slots.statistic.base.LongAdder;

public class MetricBucket {
    private final LongAdder[] counters;
    private volatile long minRt;

    public MetricBucket() {
        MetricEvent[] events = MetricEvent.values();
        this.counters = new LongAdder[events.length];
        for (MetricEvent event : events) {
            this.counters[event.ordinal()] = new LongAdder();
        }
        this.initMinRt();
    }

    private void initMinRt() {
        this.minRt = Constants.TIME_DROP_VALVE;
    }

    public MetricBucket reset() {
        for (MetricEvent event : MetricEvent.values()) {
            this.counters[event.ordinal()].reset();
        }
        this.initMinRt();
        return this;
    }

    public long get(MetricEvent event) {
        return this.counters[event.ordinal()].sum();
    }

    public MetricBucket add(MetricEvent event, long n) {
        this.counters[event.ordinal()].add(n);
        return this;
    }

    public long pass() {
        return this.get(MetricEvent.PASS);
    }

    public long block() {
        return this.get(MetricEvent.BLOCK);
    }

    public long exception() {
        return this.get(MetricEvent.EXCEPTION);
    }

    public long rt() {
        return this.get(MetricEvent.RT);
    }

    public long minRt() {
        return this.minRt;
    }

    public long success() {
        return this.get(MetricEvent.SUCCESS);
    }

    public void addPass(int n) {
        this.add(MetricEvent.PASS, n);
    }

    public void addException(int n) {
        this.add(MetricEvent.EXCEPTION, n);
    }

    public void addBlock(int n) {
        this.add(MetricEvent.BLOCK, n);
    }

    public void addSuccess(int n) {
        this.add(MetricEvent.SUCCESS, n);
    }

    public void addRT(long rt) {
        this.add(MetricEvent.RT, rt);
        if (rt < this.minRt) {
            this.minRt = rt;
        }
    }
}

