/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource;

import com.alibaba.csp.sentinel.datasource.ConfigParser;
import com.alibaba.csp.sentinel.datasource.DataSource;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.SentinelProperty;

public abstract class AbstractDataSource<S, T>
implements DataSource<S, T> {
    protected final ConfigParser<S, T> parser;
    protected final SentinelProperty<T> property;

    public AbstractDataSource(ConfigParser<S, T> parser) {
        if (parser == null) {
            throw new IllegalArgumentException("parser can't be null");
        }
        this.parser = parser;
        this.property = new DynamicSentinelProperty();
    }

    @Override
    public T loadConfig() throws Exception {
        Object readValue = this.readSource();
        T value = this.parser.parse(readValue);
        return value;
    }

    public T loadConfig(S conf) throws Exception {
        T value = this.parser.parse(conf);
        return value;
    }

    @Override
    public SentinelProperty<T> getProperty() {
        return this.property;
    }

    @Override
    public void writeDataSource(T values) throws Exception {
        throw new UnsupportedOperationException();
    }
}

