/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource.redis;

import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.redis.config.RedisConnectionConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class RedisDataSource<T>
extends AbstractDataSource<String, T> {
    private final RedisClient redisClient;
    private final String ruleKey;

    public RedisDataSource(RedisConnectionConfig connectionConfig, String ruleKey, String channel, Converter<String, T> parser) {
        super(parser);
        AssertUtil.notNull((Object)connectionConfig, (String)"Redis connection config can not be null");
        AssertUtil.notEmpty((String)ruleKey, (String)"Redis ruleKey can not be empty");
        AssertUtil.notEmpty((String)channel, (String)"Redis subscribe channel can not be empty");
        this.redisClient = this.getRedisClient(connectionConfig);
        this.ruleKey = ruleKey;
        this.loadInitialConfig();
        this.subscribeFromChannel(channel);
    }

    private RedisClient getRedisClient(RedisConnectionConfig connectionConfig) {
        if (connectionConfig.getRedisSentinels().size() == 0) {
            RecordLog.info((String)"[RedisDataSource] Creating stand-alone mode Redis client", (Object[])new Object[0]);
            return this.getRedisStandaloneClient(connectionConfig);
        }
        RecordLog.info((String)"[RedisDataSource] Creating Redis Sentinel mode Redis client", (Object[])new Object[0]);
        return this.getRedisSentinelClient(connectionConfig);
    }

    private RedisClient getRedisStandaloneClient(RedisConnectionConfig connectionConfig) {
        char[] password = connectionConfig.getPassword();
        String clientName = connectionConfig.getClientName();
        RedisURI.Builder redisUriBuilder = RedisURI.builder();
        redisUriBuilder.withHost(connectionConfig.getHost()).withPort(connectionConfig.getPort()).withDatabase(connectionConfig.getDatabase()).withTimeout(Duration.ofMillis(connectionConfig.getTimeout()));
        if (password != null) {
            redisUriBuilder.withPassword(connectionConfig.getPassword());
        }
        if (StringUtil.isNotEmpty((String)connectionConfig.getClientName())) {
            redisUriBuilder.withClientName(clientName);
        }
        return RedisClient.create((RedisURI)redisUriBuilder.build());
    }

    private RedisClient getRedisSentinelClient(RedisConnectionConfig connectionConfig) {
        char[] password = connectionConfig.getPassword();
        String clientName = connectionConfig.getClientName();
        RedisURI.Builder sentinelRedisUriBuilder = RedisURI.builder();
        for (RedisConnectionConfig config : connectionConfig.getRedisSentinels()) {
            sentinelRedisUriBuilder.withSentinel(config.getHost(), config.getPort());
        }
        if (password != null) {
            sentinelRedisUriBuilder.withPassword(connectionConfig.getPassword());
        }
        if (StringUtil.isNotEmpty((String)connectionConfig.getClientName())) {
            sentinelRedisUriBuilder.withClientName(clientName);
        }
        sentinelRedisUriBuilder.withSentinelMasterId(connectionConfig.getRedisSentinelMasterId()).withTimeout(connectionConfig.getTimeout(), TimeUnit.MILLISECONDS);
        return RedisClient.create((RedisURI)sentinelRedisUriBuilder.build());
    }

    private void subscribeFromChannel(String channel) {
        StatefulRedisPubSubConnection pubSubConnection = this.redisClient.connectPubSub();
        DelegatingRedisPubSubListener adapterListener = new DelegatingRedisPubSubListener();
        pubSubConnection.addListener((RedisPubSubListener)adapterListener);
        RedisPubSubCommands sync = pubSubConnection.sync();
        sync.subscribe((Object[])new String[]{channel});
    }

    private void loadInitialConfig() {
        try {
            Object newValue = this.loadConfig();
            if (newValue == null) {
                RecordLog.warn((String)"[RedisDataSource] WARN: initial config is null, you may have to check your data source", (Object[])new Object[0]);
            }
            this.getProperty().updateValue(newValue);
        }
        catch (Exception ex) {
            RecordLog.warn((String)"[RedisDataSource] Error when loading initial config", (Throwable)ex);
        }
    }

    public String readSource() {
        if (this.redisClient == null) {
            throw new IllegalStateException("Redis client has not been initialized or error occurred");
        }
        RedisCommands stringRedisCommands = this.redisClient.connect().sync();
        return (String)stringRedisCommands.get((Object)this.ruleKey);
    }

    public void close() {
        this.redisClient.shutdown();
    }

    private class DelegatingRedisPubSubListener
    extends RedisPubSubAdapter<String, String> {
        DelegatingRedisPubSubListener() {
        }

        public void message(String channel, String message) {
            RecordLog.info((String)String.format("[RedisDataSource] New property value received for channel %s: %s", channel, message), (Object[])new Object[0]);
            RedisDataSource.this.getProperty().updateValue(RedisDataSource.this.parser.convert((Object)message));
        }
    }
}

