/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.dubbo;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.dubbo.AbstractDubboFilter;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.SentinelRpcException;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;

@Activate(group={"consumer"})
public class SentinelDubboConsumerFilter
extends AbstractDubboFilter
implements Filter {
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Entry interfaceEntry = null;
        Entry methodEntry = null;
        try {
            String resourceName = this.getResourceName(invoker, invocation);
            ContextUtil.enter((String)resourceName);
            interfaceEntry = SphU.entry((String)invoker.getInterface().getName(), (EntryType)EntryType.OUT);
            methodEntry = SphU.entry((String)resourceName, (EntryType)EntryType.OUT);
            Result result = invoker.invoke(invocation);
            return result;
        }
        catch (BlockException e) {
            throw new SentinelRpcException((Throwable)e);
        }
        catch (RpcException e) {
            Tracer.trace((Throwable)e);
            throw e;
        }
        finally {
            if (methodEntry != null) {
                methodEntry.exit();
            }
            if (interfaceEntry != null) {
                interfaceEntry.exit();
            }
            ContextUtil.exit();
        }
    }
}

