/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.okhttp;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.okhttp.SentinelOkHttpConfig;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class SentinelOkHttpInterceptor
implements Interceptor {
    private final SentinelOkHttpConfig config;

    public SentinelOkHttpInterceptor() {
        this.config = new SentinelOkHttpConfig();
    }

    public SentinelOkHttpInterceptor(SentinelOkHttpConfig config) {
        AssertUtil.notNull((Object)config, (String)"config cannot be null");
        this.config = config;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Entry entry = null;
        try {
            Request request = chain.request();
            String name = this.config.getResourceExtractor().extract(request, chain.connection());
            if (StringUtil.isNotBlank((String)this.config.getResourcePrefix())) {
                name = this.config.getResourcePrefix() + name;
            }
            entry = SphU.entry((String)name, (int)1, (EntryType)EntryType.OUT);
            Response response = chain.proceed(request);
            return response;
        }
        catch (BlockException e) {
            Response response = this.config.getFallback().handle(chain.request(), chain.connection(), e);
            return response;
        }
        catch (IOException ex) {
            Tracer.traceEntry((Throwable)ex, entry);
            throw ex;
        }
        finally {
            if (entry != null) {
                entry.exit();
            }
        }
    }
}

