/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.protocol;

import com.alibaba.dashscope.base.FullDuplexServiceParam;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.protocol.ServiceOption;
import com.alibaba.dashscope.protocol.StreamingMode;
import com.alibaba.dashscope.protocol.WebSocketEventType;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;

public class FullDuplexRequest {
    FullDuplexServiceParam param;
    ServiceOption serviceOption;

    public FullDuplexRequest(FullDuplexServiceParam param, ServiceOption option) {
        this.param = param;
        this.serviceOption = option;
    }

    public String getBaseWebSocketUrl() {
        return this.serviceOption.getBaseWebSocketUrl();
    }

    public String getApiKey() {
        return this.param.getApiKey();
    }

    public StreamingMode getStreamingMode() {
        return this.serviceOption.getStreamingMode();
    }

    public OutputMode getOutputMode() {
        return this.serviceOption.getOutputMode();
    }

    public boolean isSecurityCheck() {
        return this.param.isSecurityCheck();
    }

    public JsonObject getWebSocketPayload() {
        JsonObject request = new JsonObject();
        request.addProperty("model", this.param.getModel());
        request.addProperty("task_group", this.serviceOption.getTaskGroup());
        request.addProperty("task", this.serviceOption.getTask());
        request.addProperty("function", this.serviceOption.getFunction());
        request.add("input", (JsonElement)new JsonObject());
        if (this.param.getParameters() != null) {
            request.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(this.param.getParameters()));
        }
        if (this.param.getResources() != null) {
            request.add("resources", (JsonElement)this.param.getResources());
        }
        return request;
    }

    public JsonObject getWebSocketPayload(Object data) {
        JsonObject request = new JsonObject();
        request.addProperty("model", this.param.getModel());
        request.addProperty("task_group", this.serviceOption.getTaskGroup());
        request.addProperty("task", this.serviceOption.getTask());
        request.addProperty("function", this.serviceOption.getFunction());
        if (data instanceof ByteBuffer) {
            request.add("input", (JsonElement)new JsonObject());
        } else if (data instanceof Byte[]) {
            request.add("input", (JsonElement)new JsonObject());
        } else {
            request.add("input", JsonUtils.toJsonElement(data));
        }
        if (this.param.getParameters() != null) {
            request.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(this.param.getParameters()));
        }
        if (this.param.getResources() != null) {
            request.add("resources", (JsonElement)((JsonObject)this.param.getResources()));
        }
        return request;
    }

    public JsonObject getStartTaskMessage() {
        JsonObject header = new JsonObject();
        header.addProperty("action", WebSocketEventType.RUN_TASK.getValue());
        header.addProperty("task_id", UUID.randomUUID().toString());
        header.addProperty("streaming", this.serviceOption.getStreamingMode().getValue());
        JsonObject wsMessage = new JsonObject();
        wsMessage.add("header", (JsonElement)header);
        wsMessage.add("payload", (JsonElement)this.getWebSocketPayload());
        return wsMessage;
    }

    public JsonObject getStartTaskMessage(Object payloadData) {
        JsonObject header = new JsonObject();
        header.addProperty("action", WebSocketEventType.RUN_TASK.getValue());
        header.addProperty("task_id", UUID.randomUUID().toString());
        header.addProperty("streaming", this.serviceOption.getStreamingMode().getValue());
        JsonObject wsMessage = new JsonObject();
        wsMessage.add("header", (JsonElement)header);
        wsMessage.add("payload", (JsonElement)this.getWebSocketPayload(payloadData));
        return wsMessage;
    }

    public Flowable<Object> getStreamingData() {
        return this.param.getStreamingData();
    }

    public JsonObject getContinueMessage() {
        JsonObject header = new JsonObject();
        header.addProperty("action", WebSocketEventType.CONTINUE_TASK.getValue());
        header.addProperty("task_id", UUID.randomUUID().toString());
        header.addProperty("streaming", this.serviceOption.getStreamingMode().getValue());
        JsonObject wsMessage = new JsonObject();
        wsMessage.add("header", (JsonElement)header);
        wsMessage.add("payload", (JsonElement)this.getWebSocketPayload());
        return wsMessage;
    }

    public JsonObject getContinueMessage(String data, String taskId) {
        JsonObject header = new JsonObject();
        header.addProperty("action", WebSocketEventType.CONTINUE_TASK.getValue());
        header.addProperty("task_id", taskId);
        header.addProperty("streaming", this.serviceOption.getStreamingMode().getValue());
        JsonObject wsMessage = new JsonObject();
        wsMessage.add("header", (JsonElement)header);
        wsMessage.add("payload", (JsonElement)this.getWebSocketPayload(data));
        return wsMessage;
    }

    public JsonObject getContinueMessage(Object data, String taskId) {
        JsonObject header = new JsonObject();
        header.addProperty("action", WebSocketEventType.CONTINUE_TASK.getValue());
        header.addProperty("task_id", taskId);
        header.addProperty("streaming", this.serviceOption.getStreamingMode().getValue());
        JsonObject wsMessage = new JsonObject();
        wsMessage.add("header", (JsonElement)header);
        wsMessage.add("payload", (JsonElement)this.getWebSocketPayload(data));
        return wsMessage;
    }

    public JsonObject getFinishedTaskMessage(String taskId) {
        JsonObject header = new JsonObject();
        header.addProperty("action", WebSocketEventType.FINISH_TASK.getValue());
        header.addProperty("task_id", taskId);
        header.addProperty("streaming", this.serviceOption.getStreamingMode().getValue());
        JsonObject wsMessage = new JsonObject();
        wsMessage.add("header", (JsonElement)header);
        JsonObject payload = new JsonObject();
        payload.add("input", (JsonElement)new JsonObject());
        wsMessage.add("payload", (JsonElement)payload);
        return wsMessage;
    }

    public Map<String, String> getHeaders() {
        return this.param.getHeaders();
    }

    public String getWorkspace() {
        return this.param.getWorkspace();
    }
}

