/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.protocol;

import java.util.Arrays;

public final class ClientOptions {
    private static final String DEFAULT_NETWORK_LOGGING_LEVEL = "NONE";
    private static final String DEFAULT_SDK_LOGGING_LEVEL = "WARN";
    private String implementation;
    private String networkLoggingLevel;
    private String sdkLoggingLevel;

    public String getNetworkLoggingLevel() {
        if (this.networkLoggingLevel != null) {
            return this.networkLoggingLevel;
        }
        String logLevel = System.getenv().getOrDefault("DASHSCOPE_NETWORK_LOGGING_LEVEL", DEFAULT_NETWORK_LOGGING_LEVEL);
        if (Arrays.asList(DEFAULT_NETWORK_LOGGING_LEVEL, "BASIC", "HEADERS", "BODY").contains(logLevel)) {
            return logLevel;
        }
        return DEFAULT_NETWORK_LOGGING_LEVEL;
    }

    public String getSdkLoggingLevel() {
        if (this.sdkLoggingLevel != null) {
            return this.sdkLoggingLevel;
        }
        return System.getenv().getOrDefault("DASHSCOPE_SDK_LOGGING_LEVEL", DEFAULT_SDK_LOGGING_LEVEL);
    }

    protected ClientOptions(ClientOptionsBuilder<?, ?> b) {
        this.implementation = ((ClientOptionsBuilder)b).implementation;
        this.networkLoggingLevel = ((ClientOptionsBuilder)b).networkLoggingLevel;
        this.sdkLoggingLevel = ((ClientOptionsBuilder)b).sdkLoggingLevel;
    }

    public static ClientOptionsBuilder<?, ?> builder() {
        return new ClientOptionsBuilderImpl();
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public void setNetworkLoggingLevel(String networkLoggingLevel) {
        this.networkLoggingLevel = networkLoggingLevel;
    }

    public void setSdkLoggingLevel(String sdkLoggingLevel) {
        this.sdkLoggingLevel = sdkLoggingLevel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientOptions)) {
            return false;
        }
        ClientOptions other = (ClientOptions)o;
        String this$implementation = this.getImplementation();
        String other$implementation = other.getImplementation();
        if (this$implementation == null ? other$implementation != null : !this$implementation.equals(other$implementation)) {
            return false;
        }
        String this$networkLoggingLevel = this.getNetworkLoggingLevel();
        String other$networkLoggingLevel = other.getNetworkLoggingLevel();
        if (this$networkLoggingLevel == null ? other$networkLoggingLevel != null : !this$networkLoggingLevel.equals(other$networkLoggingLevel)) {
            return false;
        }
        String this$sdkLoggingLevel = this.getSdkLoggingLevel();
        String other$sdkLoggingLevel = other.getSdkLoggingLevel();
        return !(this$sdkLoggingLevel == null ? other$sdkLoggingLevel != null : !this$sdkLoggingLevel.equals(other$sdkLoggingLevel));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $implementation = this.getImplementation();
        result = result * 59 + ($implementation == null ? 43 : $implementation.hashCode());
        String $networkLoggingLevel = this.getNetworkLoggingLevel();
        result = result * 59 + ($networkLoggingLevel == null ? 43 : $networkLoggingLevel.hashCode());
        String $sdkLoggingLevel = this.getSdkLoggingLevel();
        result = result * 59 + ($sdkLoggingLevel == null ? 43 : $sdkLoggingLevel.hashCode());
        return result;
    }

    public String toString() {
        return "ClientOptions(implementation=" + this.getImplementation() + ", networkLoggingLevel=" + this.getNetworkLoggingLevel() + ", sdkLoggingLevel=" + this.getSdkLoggingLevel() + ")";
    }

    private static final class ClientOptionsBuilderImpl
    extends ClientOptionsBuilder<ClientOptions, ClientOptionsBuilderImpl> {
        private ClientOptionsBuilderImpl() {
        }

        @Override
        protected ClientOptionsBuilderImpl self() {
            return this;
        }

        @Override
        public ClientOptions build() {
            return new ClientOptions(this);
        }
    }

    public static abstract class ClientOptionsBuilder<C extends ClientOptions, B extends ClientOptionsBuilder<C, B>> {
        private String implementation;
        private String networkLoggingLevel;
        private String sdkLoggingLevel;

        public B implementation(String implementation) {
            this.implementation = implementation;
            return this.self();
        }

        public B networkLoggingLevel(String networkLoggingLevel) {
            this.networkLoggingLevel = networkLoggingLevel;
            return this.self();
        }

        public B sdkLoggingLevel(String sdkLoggingLevel) {
            this.sdkLoggingLevel = sdkLoggingLevel;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "ClientOptions.ClientOptionsBuilder(implementation=" + this.implementation + ", networkLoggingLevel=" + this.networkLoggingLevel + ", sdkLoggingLevel=" + this.sdkLoggingLevel + ")";
        }
    }
}

