/*
 * Decompiled with CFR 0.152.
 */
import com.alibaba.dashscope.aigc.completion.ChatCompletion;
import com.alibaba.dashscope.aigc.completion.ChatCompletionChunk;
import com.alibaba.dashscope.aigc.completion.ChatCompletionParam;
import com.alibaba.dashscope.aigc.completion.ChatCompletionStreamOptions;
import com.alibaba.dashscope.aigc.completion.ChatCompletions;
import com.alibaba.dashscope.base.FlattenHalfDuplexParamBase;
import com.alibaba.dashscope.common.ImageURL;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.common.MessageContentBase;
import com.alibaba.dashscope.common.MessageContentImageURL;
import com.alibaba.dashscope.common.MessageContentText;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.tools.FunctionDefinition;
import com.alibaba.dashscope.tools.ToolCallBase;
import com.alibaba.dashscope.tools.ToolCallFunction;
import com.alibaba.dashscope.tools.ToolFunction;
import com.alibaba.dashscope.utils.JsonUtils;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import io.reactivex.Flowable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChatCompletionTest {
    public static void testGeneralRequest() throws ApiException, NoApiKeyException, InputRequiredException {
        ChatCompletions chatCompletions = new ChatCompletions();
        Object system = ((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().content("You are a helpful assistant.")).role("system")).build();
        Object user = ((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().role("user")).content("hello")).build();
        FlattenHalfDuplexParamBase chatCompletionParam = ((ChatCompletionParam.ChatCompletionParamBuilder)((ChatCompletionParam.ChatCompletionParamBuilder)((ChatCompletionParam.ChatCompletionParamBuilder)((ChatCompletionParam.ChatCompletionParamBuilder)ChatCompletionParam.builder().logprobs(true)).topLogprobs(20)).model("gpt-4o")).messages(Arrays.asList(system, user))).build();
        ChatCompletion chatCompletion = chatCompletions.call((ChatCompletionParam)chatCompletionParam);
        System.out.println(chatCompletion);
    }

    public static void testGeneralRequestStream() throws ApiException, NoApiKeyException, InputRequiredException {
        ChatCompletions chatCompletions = new ChatCompletions();
        Object system = ((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().content("You are a helpful assistant.")).role("system")).build();
        Object user = ((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().role("user")).content("hello")).build();
        FlattenHalfDuplexParamBase chatCompletionParam = ((ChatCompletionParam.ChatCompletionParamBuilder)((ChatCompletionParam.ChatCompletionParamBuilder)((ChatCompletionParam.ChatCompletionParamBuilder)((ChatCompletionParam.ChatCompletionParamBuilder)ChatCompletionParam.builder().stream(true)).streamOptions((ChatCompletionStreamOptions)((ChatCompletionStreamOptions.ChatCompletionStreamOptionsBuilder)ChatCompletionStreamOptions.builder().includeUsage(true)).build())).model("gpt-4o")).messages(Arrays.asList(system, user))).build();
        Flowable<ChatCompletionChunk> chatCompletionChunks = chatCompletions.streamCall((ChatCompletionParam)chatCompletionParam);
        chatCompletionChunks.blockingForEach(item -> System.out.println(item));
    }

    public static void testGeneralRequestFunction() throws ApiException, NoApiKeyException, InputRequiredException {
        ChatCompletions chatCompletions = new ChatCompletions();
        ArrayList<Message> messages = new ArrayList<Message>();
        Object system = ((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().content("Don't make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.")).role("system")).build();
        Object user = ((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().role("user")).content("What's the weather like today?")).build();
        messages.add((Message)system);
        messages.add((Message)user);
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON);
        SchemaGeneratorConfig config = configBuilder.with(Option.EXTRA_OPEN_API_FORMAT_VALUES, new Option[0]).without(Option.FLATTENED_ENUMS_FROM_TOSTRING, new Option[0]).build();
        SchemaGenerator generator = new SchemaGenerator(config);
        ObjectNode jsonSchema = generator.generateSchema(GetCurrentWeather.class, new Type[0]);
        Object getCurrentWeatherFunction = ((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)FunctionDefinition.builder().name("get_current_weather")).description("Get the current weather")).parameters(JsonUtils.parseString(jsonSchema.toString()).getAsJsonObject())).build();
        jsonSchema = generator.generateSchema(GetNDayWeather.class, new Type[0]);
        Object getNDaysWeatherFunction = ((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)FunctionDefinition.builder().name("get_n_day_weather_forecast")).description("Get an N-day weather forecast")).parameters(JsonUtils.parseString(jsonSchema.toString()).getAsJsonObject())).build();
        FlattenHalfDuplexParamBase chatCompletionParam = ((ChatCompletionParam.ChatCompletionParamBuilder)((ChatCompletionParam.ChatCompletionParamBuilder)((ChatCompletionParam.ChatCompletionParamBuilder)ChatCompletionParam.builder().model("gpt-4o")).messages(messages)).tools(Arrays.asList(((ToolFunction.ToolFunctionBuilder)ToolFunction.builder().function((FunctionDefinition)getCurrentWeatherFunction)).build(), ((ToolFunction.ToolFunctionBuilder)ToolFunction.builder().function((FunctionDefinition)getNDaysWeatherFunction)).build()))).build();
        ChatCompletion chatCompletion = chatCompletions.call((ChatCompletionParam)chatCompletionParam);
        System.out.println(chatCompletion);
        messages.add(chatCompletion.getChoices().get(0).getMessage());
        messages.add((Message)((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().role("user")).content("I'm in Glasgow, Scotland.")).build());
        ((ChatCompletionParam)chatCompletionParam).setMessages(messages);
        chatCompletion = chatCompletions.call((ChatCompletionParam)chatCompletionParam);
        System.out.println(chatCompletion);
        for (ChatCompletion.Choice choice : chatCompletion.getChoices()) {
            messages.add(choice.getMessage());
            if (choice.getMessage().getToolCalls() == null) continue;
            for (ToolCallBase toolCall : choice.getMessage().getToolCalls()) {
                Object toolResultMessage;
                String weather;
                Object fn;
                if (!toolCall.getType().equals("function")) continue;
                String functionName = ((ToolCallFunction)toolCall).getFunction().getName();
                String functionArgument = ((ToolCallFunction)toolCall).getFunction().getArguments();
                if (functionName.equals("get_current_weather")) {
                    fn = JsonUtils.fromJson(functionArgument, GetCurrentWeather.class);
                    weather = ((GetCurrentWeather)fn).call();
                    toolResultMessage = ((Message.MessageBuilder)((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().role("tool")).content(String.valueOf(weather))).toolCallId(toolCall.getId())).build();
                    messages.add((Message)toolResultMessage);
                    continue;
                }
                if (!functionName.equals("get_n_day_weather_forecast")) continue;
                fn = JsonUtils.fromJson(functionArgument, GetNDayWeather.class);
                weather = ((GetNDayWeather)fn).call();
                toolResultMessage = ((Message.MessageBuilder)((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().role("tool")).content(String.valueOf(weather))).toolCallId(toolCall.getId())).build();
                messages.add((Message)toolResultMessage);
            }
        }
        ((ChatCompletionParam)chatCompletionParam).setMessages(messages);
        chatCompletion = chatCompletions.call((ChatCompletionParam)chatCompletionParam);
        System.out.println(chatCompletion);
    }

    public static void testGeneralRequestFunctionParallel() throws ApiException, NoApiKeyException, InputRequiredException {
        ChatCompletions chatCompletions = new ChatCompletions();
        ArrayList<Message> messages = new ArrayList<Message>();
        Object system = ((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().content("Don't make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.")).role("system")).build();
        Object user = ((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().role("user")).content("What's the weather like?")).build();
        messages.add((Message)system);
        messages.add((Message)user);
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON);
        SchemaGeneratorConfig config = configBuilder.with(Option.EXTRA_OPEN_API_FORMAT_VALUES, new Option[0]).without(Option.FLATTENED_ENUMS_FROM_TOSTRING, new Option[0]).build();
        SchemaGenerator generator = new SchemaGenerator(config);
        ObjectNode jsonSchema = generator.generateSchema(GetCurrentWeather.class, new Type[0]);
        Object getCurrentWeatherFunction = ((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)FunctionDefinition.builder().name("get_current_weather")).description("Get the current weather")).parameters(JsonUtils.parseString(jsonSchema.toString()).getAsJsonObject())).build();
        jsonSchema = generator.generateSchema(GetNDayWeather.class, new Type[0]);
        Object getNDaysWeatherFunction = ((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)((FunctionDefinition.FunctionDefinitionBuilder)FunctionDefinition.builder().name("get_n_day_weather_forecast")).description("Get an N-day weather forecast")).parameters(JsonUtils.parseString(jsonSchema.toString()).getAsJsonObject())).build();
        FlattenHalfDuplexParamBase chatCompletionParam = ((ChatCompletionParam.ChatCompletionParamBuilder)((ChatCompletionParam.ChatCompletionParamBuilder)((ChatCompletionParam.ChatCompletionParamBuilder)ChatCompletionParam.builder().model("gpt-4o")).messages(messages)).tools(Arrays.asList(((ToolFunction.ToolFunctionBuilder)ToolFunction.builder().function((FunctionDefinition)getCurrentWeatherFunction)).build(), ((ToolFunction.ToolFunctionBuilder)ToolFunction.builder().function((FunctionDefinition)getNDaysWeatherFunction)).build()))).build();
        ChatCompletion chatCompletion = chatCompletions.call((ChatCompletionParam)chatCompletionParam);
        System.out.println(chatCompletion);
        messages.add(chatCompletion.getChoices().get(0).getMessage());
        messages.add((Message)((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().role("user")).content("what is the weather going to be like in San Francisco and Glasgow over the next 4 days")).build());
        ((ChatCompletionParam)chatCompletionParam).setMessages(messages);
        chatCompletion = chatCompletions.call((ChatCompletionParam)chatCompletionParam);
        System.out.println(chatCompletion);
        for (ChatCompletion.Choice choice : chatCompletion.getChoices()) {
            messages.add(choice.getMessage());
            if (choice.getMessage().getToolCalls() == null) continue;
            for (ToolCallBase toolCall : choice.getMessage().getToolCalls()) {
                Object toolResultMessage;
                String weather;
                Object fn;
                if (!toolCall.getType().equals("function")) continue;
                String functionName = ((ToolCallFunction)toolCall).getFunction().getName();
                String functionArgument = ((ToolCallFunction)toolCall).getFunction().getArguments();
                if (functionName.equals("get_current_weather")) {
                    fn = JsonUtils.fromJson(functionArgument, GetCurrentWeather.class);
                    weather = ((GetCurrentWeather)fn).call();
                    toolResultMessage = ((Message.MessageBuilder)((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().role("tool")).content(String.valueOf(weather))).toolCallId(toolCall.getId())).build();
                    messages.add((Message)toolResultMessage);
                    continue;
                }
                if (!functionName.equals("get_n_day_weather_forecast")) continue;
                fn = JsonUtils.fromJson(functionArgument, GetNDayWeather.class);
                weather = ((GetNDayWeather)fn).call();
                toolResultMessage = ((Message.MessageBuilder)((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().role("tool")).content(String.valueOf(weather))).toolCallId(toolCall.getId())).build();
                messages.add((Message)toolResultMessage);
            }
        }
        ((ChatCompletionParam)chatCompletionParam).setMessages(messages);
        chatCompletion = chatCompletions.call((ChatCompletionParam)chatCompletionParam);
        System.out.println(chatCompletion);
    }

    public static void testMultiModalRequest() throws ApiException, NoApiKeyException, InputRequiredException {
        ChatCompletions chatCompletions = new ChatCompletions();
        Object system = ((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().content("You are a helpful assistant.")).role("system")).build();
        List<MessageContentBase> messageContents = Arrays.asList(((MessageContentText.MessageContentTextBuilder)MessageContentText.builder().text("What\u2019s in this image?")).build(), ((MessageContentImageURL.MessageContentImageURLBuilder)MessageContentImageURL.builder().imageURL((ImageURL)((ImageURL.ImageURLBuilder)((ImageURL.ImageURLBuilder)ImageURL.builder().url("https://upload.wikimedia.org/wikipedia/commons/thumb/d/dd/Gfp-wisconsin-madison-the-nature-boardwalk.jpg/2560px-Gfp-wisconsin-madison-the-nature-boardwalk.jpg")).detail("high")).build())).build());
        Object user = ((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().role("user")).contents(messageContents)).build();
        FlattenHalfDuplexParamBase chatCompletionParam = ((ChatCompletionParam.ChatCompletionParamBuilder)((ChatCompletionParam.ChatCompletionParamBuilder)ChatCompletionParam.builder().model("gpt-4o")).messages(Arrays.asList(system, user))).build();
        ChatCompletion chatCompletion = chatCompletions.call((ChatCompletionParam)chatCompletionParam);
        System.out.println(chatCompletion);
    }

    public static void main(String[] args) {
        try {
            ChatCompletionTest.testMultiModalRequest();
        }
        catch (ApiException | InputRequiredException | NoApiKeyException e) {
            System.out.println(e.getMessage());
        }
        System.exit(0);
    }

    public class GetNDayWeather {
        private String location;
        private String format;
        Integer numDays;

        public GetNDayWeather(String location, Integer nDays, String format) {
            this.location = location;
            this.format = format;
            this.numDays = nDays;
        }

        public String call() {
            float minTemperature = -10.0f;
            float maxTemperature = 60.0f;
            return String.format("The %s %s days, format: %s temperature: %s", this.location, this.numDays, this.format, (double)minTemperature + Math.random() * (double)(maxTemperature - minTemperature));
        }
    }

    public class GetCurrentWeather {
        private String location;
        private String format;

        public GetCurrentWeather(String location, String format) {
            this.location = location;
            this.format = format;
        }

        public String call() {
            float minTemperature = -10.0f;
            float maxTemperature = 60.0f;
            return String.format("The %s, format: %s temperature: %s", this.location, this.format, (double)minTemperature + Math.random() * (double)(maxTemperature - minTemperature));
        }
    }
}

