/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.multimodalconversation;

import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationOutput;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationUsage;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiModalConversationResult {
    private static final Logger log = LoggerFactory.getLogger(MultiModalConversationResult.class);
    private String requestId;
    private MultiModalConversationUsage usage;
    private MultiModalConversationOutput output;

    private MultiModalConversationResult() {
    }

    public static MultiModalConversationResult fromDashScopeResult(DashScopeResult dashScopeResult) {
        MultiModalConversationResult result = new MultiModalConversationResult();
        result.setRequestId(dashScopeResult.getRequestId());
        if (dashScopeResult.getUsage() != null) {
            result.setUsage(JsonUtils.fromJsonObject((JsonElement)dashScopeResult.getUsage().getAsJsonObject(), MultiModalConversationUsage.class));
        }
        if (dashScopeResult.getOutput() != null) {
            result.setOutput(JsonUtils.fromJsonObject((JsonElement)((JsonObject)dashScopeResult.getOutput()), MultiModalConversationOutput.class));
        } else {
            log.error(String.format("Result no output: %s", dashScopeResult));
        }
        return result;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public MultiModalConversationUsage getUsage() {
        return this.usage;
    }

    public MultiModalConversationOutput getOutput() {
        return this.output;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setUsage(MultiModalConversationUsage usage) {
        this.usage = usage;
    }

    public void setOutput(MultiModalConversationOutput output) {
        this.output = output;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiModalConversationResult)) {
            return false;
        }
        MultiModalConversationResult other = (MultiModalConversationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        MultiModalConversationUsage this$usage = this.getUsage();
        MultiModalConversationUsage other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage)) {
            return false;
        }
        MultiModalConversationOutput this$output = this.getOutput();
        MultiModalConversationOutput other$output = other.getOutput();
        return !(this$output == null ? other$output != null : !((Object)this$output).equals(other$output));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiModalConversationResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        MultiModalConversationUsage $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        MultiModalConversationOutput $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
        return result;
    }

    public String toString() {
        return "MultiModalConversationResult(requestId=" + this.getRequestId() + ", usage=" + this.getUsage() + ", output=" + this.getOutput() + ")";
    }
}

