/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.asr.vocabulary;

import com.alibaba.dashscope.common.DashScopeResult;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

public class Vocabulary {
    @SerializedName(value="vocabulary_id")
    String vocabularyId;
    @SerializedName(value="gmt_create")
    String gmtCreate;
    @SerializedName(value="gmt_modified")
    String gmtModified;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="target_model")
    String targetModel;
    @SerializedName(value="vocabulary")
    JsonArray vocabulary;
    @SerializedName(value="request_id")
    String requestId;
    @SerializedName(value="data")
    JsonObject data;

    public static Vocabulary vocabularyFromCreateResult(DashScopeResult dashScopeResult) {
        Vocabulary vocabulary = new Vocabulary();
        JsonObject output = (JsonObject)dashScopeResult.getOutput();
        if (output.has("vocabulary_id")) {
            vocabulary.vocabularyId = output.get("vocabulary_id").getAsString();
            vocabulary.requestId = dashScopeResult.getRequestId();
            vocabulary.data = output;
            return vocabulary;
        }
        return null;
    }

    public static Vocabulary[] vocabularyListFromListResult(DashScopeResult dashScopeResult) {
        JsonObject output = (JsonObject)dashScopeResult.getOutput();
        if (output.has("vocabulary_list")) {
            int vocabularyListSize = output.getAsJsonArray("vocabulary_list").size();
            JsonArray vocabularyList = output.getAsJsonArray("vocabulary_list");
            Vocabulary[] vocabularies = new Vocabulary[vocabularyListSize];
            for (int i = 0; i < vocabularyListSize; ++i) {
                JsonObject voiceJosn = vocabularyList.get(i).getAsJsonObject();
                Vocabulary vocabulary = new Vocabulary();
                vocabulary.gmtModified = voiceJosn.get("gmt_modified").getAsString();
                vocabulary.gmtCreate = voiceJosn.get("gmt_create").getAsString();
                vocabulary.vocabularyId = voiceJosn.get("vocabulary_id").getAsString();
                vocabulary.status = voiceJosn.get("status").getAsString();
                vocabulary.requestId = dashScopeResult.getRequestId();
                vocabulary.data = voiceJosn;
                vocabularies[i] = vocabulary;
            }
            return vocabularies;
        }
        return null;
    }

    public static Vocabulary vocabularyFromQueryResult(DashScopeResult dashScopeResult) {
        Vocabulary vocabulary = new Vocabulary();
        JsonObject output = (JsonObject)dashScopeResult.getOutput();
        System.out.println(output);
        if (output.has("vocabulary")) {
            vocabulary.gmtModified = output.get("gmt_modified").getAsString();
            vocabulary.gmtCreate = output.get("gmt_create").getAsString();
            vocabulary.status = output.get("status").getAsString();
            vocabulary.targetModel = output.get("target_model").getAsString();
            vocabulary.vocabulary = output.getAsJsonArray("vocabulary");
            vocabulary.requestId = dashScopeResult.getRequestId();
            vocabulary.data = output;
            return vocabulary;
        }
        return null;
    }

    public String toString() {
        return "Vocabulary{vocabularyId='" + this.vocabularyId + '\'' + ", gmtCreate='" + this.gmtCreate + '\'' + ", gmtModified='" + this.gmtModified + '\'' + ", status='" + this.status + '\'' + ", targetModel='" + this.targetModel + '\'' + ", vocabulary=" + this.vocabulary + ", requestId='" + this.requestId + '\'' + '}';
    }

    public String getVocabularyId() {
        return this.vocabularyId;
    }

    public String getGmtCreate() {
        return this.gmtCreate;
    }

    public String getGmtModified() {
        return this.gmtModified;
    }

    public String getStatus() {
        return this.status;
    }

    public String getTargetModel() {
        return this.targetModel;
    }

    public JsonArray getVocabulary() {
        return this.vocabulary;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public JsonObject getData() {
        return this.data;
    }

    public void setVocabularyId(String vocabularyId) {
        this.vocabularyId = vocabularyId;
    }

    public void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtModified(String gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTargetModel(String targetModel) {
        this.targetModel = targetModel;
    }

    public void setVocabulary(JsonArray vocabulary) {
        this.vocabulary = vocabulary;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setData(JsonObject data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vocabulary)) {
            return false;
        }
        Vocabulary other = (Vocabulary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$vocabularyId = this.getVocabularyId();
        String other$vocabularyId = other.getVocabularyId();
        if (this$vocabularyId == null ? other$vocabularyId != null : !this$vocabularyId.equals(other$vocabularyId)) {
            return false;
        }
        String this$gmtCreate = this.getGmtCreate();
        String other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !this$gmtCreate.equals(other$gmtCreate)) {
            return false;
        }
        String this$gmtModified = this.getGmtModified();
        String other$gmtModified = other.getGmtModified();
        if (this$gmtModified == null ? other$gmtModified != null : !this$gmtModified.equals(other$gmtModified)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$targetModel = this.getTargetModel();
        String other$targetModel = other.getTargetModel();
        if (this$targetModel == null ? other$targetModel != null : !this$targetModel.equals(other$targetModel)) {
            return false;
        }
        JsonArray this$vocabulary = this.getVocabulary();
        JsonArray other$vocabulary = other.getVocabulary();
        if (this$vocabulary == null ? other$vocabulary != null : !this$vocabulary.equals(other$vocabulary)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        JsonObject this$data = this.getData();
        JsonObject other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Vocabulary;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $vocabularyId = this.getVocabularyId();
        result = result * 59 + ($vocabularyId == null ? 43 : $vocabularyId.hashCode());
        String $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : $gmtCreate.hashCode());
        String $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : $gmtModified.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $targetModel = this.getTargetModel();
        result = result * 59 + ($targetModel == null ? 43 : $targetModel.hashCode());
        JsonArray $vocabulary = this.getVocabulary();
        result = result * 59 + ($vocabulary == null ? 43 : $vocabulary.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        JsonObject $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }
}

